<?php
/**
 * Statický převodník pro RealityMorava.cz. Číselníky má zadrátované v sobě.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_RealityMorava_Static implements  Dalten_AddressConverter_RealityMorava_Interface
{
	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @throws Dalten_Export_Exception_HumanReadable Když se pokoušíme převádět mimo pole jeho působnosti (ČR).
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		if ($input['nemovitost_uir_stat']!=='CZ') {
			throw new Dalten_Export_Exception_HumanReadable('Možno exportovat pouze na území ČR!');
		}

		$prevodnik = self::_getPrevodnikCz();

		$kraj = $input['nemovitost_uir_kraj_kod'];
		$okres = $input['nemovitost_uir_okres_kod'];

		$input['nemovitost_uir_stat'] = 101; //Česká republika
		if (isset($prevodnik['nemovitost_uir_kraj_kod'][$kraj])) {
			$input['nemovitost_uir_kraj_kod'] = $prevodnik['nemovitost_uir_kraj_kod'][$kraj];
		}
		if (isset($prevodnik['nemovitost_uir_okres_kod'][$okres])) {
			$input['nemovitost_uir_okres_kod'] = $prevodnik['nemovitost_uir_okres_kod'][$okres];
		}

		return $input;
	}

	/**
	 * Pomocná funkce. Vrátí převodní pole pro ČR.
	 *
	 * @static
	 * @return array Hotové převodní pole.
	 */
	private static function _getPrevodnikCz()
	{
		$prevodnik = array();
		$prevodnik['nemovitost_uir_kraj_kod'][19]  = '1001';  // Hlavni mesto Praha
		$prevodnik['nemovitost_uir_kraj_kod'][27]  = '1011'; // Streedocesky
		$prevodnik['nemovitost_uir_kraj_kod'][35]  = '1003';  // Jihocesky
		$prevodnik['nemovitost_uir_kraj_kod'][43]  = '1010'; // Plzezsky
		$prevodnik['nemovitost_uir_kraj_kod'][51]  = '1007';  // Karlovarsky
		$prevodnik['nemovitost_uir_kraj_kod'][60]  = '1013'; // Ustecky
		$prevodnik['nemovitost_uir_kraj_kod'][78]  = '1008';  // Liberecky
		$prevodnik['nemovitost_uir_kraj_kod'][86]  = '1005';  // Kralovehradecky
		$prevodnik['nemovitost_uir_kraj_kod'][94]  = '1004'; // Pardubicky
		$prevodnik['nemovitost_uir_kraj_kod'][108] = '1006'; // Vysocina
		$prevodnik['nemovitost_uir_kraj_kod'][116] = '2002';  // Jihomoravsky
		$prevodnik['nemovitost_uir_kraj_kod'][124] = '2009';  // Olomoucky
		$prevodnik['nemovitost_uir_kraj_kod'][132] = '2012';  // Moravskoslezsky
		$prevodnik['nemovitost_uir_kraj_kod'][141] = '2014'; // Zlinsky

		//$prevodnik['nemovitost_uir_okres_kod'][3100] = 2002; // Hlavni mesto
		$prevodnik['nemovitost_uir_okres_kod'][3201] = 10113201; // Benesov
		$prevodnik['nemovitost_uir_okres_kod'][3202] = 10113202; // Beroun
		$prevodnik['nemovitost_uir_okres_kod'][3203] = 10113203; // Kladno
		$prevodnik['nemovitost_uir_okres_kod'][3204] = 10113204; // Kolin
		$prevodnik['nemovitost_uir_okres_kod'][3205] = 10113205; // Kutna Hora
		$prevodnik['nemovitost_uir_okres_kod'][3206] = 10113206; // Melnik
		$prevodnik['nemovitost_uir_okres_kod'][3207] = 10113207; // Mlada Boleslav
		$prevodnik['nemovitost_uir_okres_kod'][3208] = 10113208; // Nymburk
		$prevodnik['nemovitost_uir_okres_kod'][3209] = 10113209; // Praha-vychod
		$prevodnik['nemovitost_uir_okres_kod'][3210] = 10113210; // Praha-zapad
		$prevodnik['nemovitost_uir_okres_kod'][3211] = 10113211; // Pribram
		$prevodnik['nemovitost_uir_okres_kod'][3212] = 10113212; // Rakovn??k
		$prevodnik['nemovitost_uir_okres_kod'][3301] = 10033301; // Ceske Budejovice
		$prevodnik['nemovitost_uir_okres_kod'][3302] = 10033302; // Cesky Krumlov
		$prevodnik['nemovitost_uir_okres_kod'][3303] = 10033303; // Jindrichuv Hradec
		$prevodnik['nemovitost_uir_okres_kod'][3304] = 10063304; // Pelhrimov
		$prevodnik['nemovitost_uir_okres_kod'][3305] = 10033305; // Pisek
		$prevodnik['nemovitost_uir_okres_kod'][3306] = 10033306; // Prachatice
		$prevodnik['nemovitost_uir_okres_kod'][3307] = 10033307; // Strakonice
		$prevodnik['nemovitost_uir_okres_kod'][3308] = 10033308; // Tabor
		$prevodnik['nemovitost_uir_okres_kod'][3401] = 10103401; // Domazlice
		$prevodnik['nemovitost_uir_okres_kod'][3402] = 10073402; // Cheb
		$prevodnik['nemovitost_uir_okres_kod'][3403] = 10073403; // Karlovy Vary
		$prevodnik['nemovitost_uir_okres_kod'][3404] = 10103404; // Klatovy
		$prevodnik['nemovitost_uir_okres_kod'][3405] = 10103405; // Plzen-mesto
		$prevodnik['nemovitost_uir_okres_kod'][3406] = 10103406; // Plzen-jih
		$prevodnik['nemovitost_uir_okres_kod'][3407] = 10103407; // Plzen-sever
		$prevodnik['nemovitost_uir_okres_kod'][3408] = 10103408; // Rokycany
		$prevodnik['nemovitost_uir_okres_kod'][3409] = 10073409; // Sokolov
		$prevodnik['nemovitost_uir_okres_kod'][3410] = 10103410; // Tachov
		$prevodnik['nemovitost_uir_okres_kod'][3501] = 10083501; // Ceska Lipa
		$prevodnik['nemovitost_uir_okres_kod'][3502] = 10133502; // Decin
		$prevodnik['nemovitost_uir_okres_kod'][3503] = 10133503; // Chomutov
		$prevodnik['nemovitost_uir_okres_kod'][3504] = 10083504; // Jablonec nad Nisou
		$prevodnik['nemovitost_uir_okres_kod'][3505] = 10083505; // Liberec
		$prevodnik['nemovitost_uir_okres_kod'][3506] = 10133506; // Litomerice
		$prevodnik['nemovitost_uir_okres_kod'][3507] = 10133507; // Louny
		$prevodnik['nemovitost_uir_okres_kod'][3508] = 10133508; // Most
		$prevodnik['nemovitost_uir_okres_kod'][3509] = 10133509; // Teplice
		$prevodnik['nemovitost_uir_okres_kod'][3510] = 10133510; // Usti nad Labem
		$prevodnik['nemovitost_uir_okres_kod'][3601] = 10063601; // Havlickuv Brod
		$prevodnik['nemovitost_uir_okres_kod'][3602] = 10053602; // Hradec Kralove
		$prevodnik['nemovitost_uir_okres_kod'][3603] = 10043603; // Chrudim
		$prevodnik['nemovitost_uir_okres_kod'][3604] = 10053604; // Jicin
		$prevodnik['nemovitost_uir_okres_kod'][3605] = 10053605; // Nachod
		$prevodnik['nemovitost_uir_okres_kod'][3606] = 10043606; // Pardubice
		$prevodnik['nemovitost_uir_okres_kod'][3607] = 10053607; // Rychnov nad Kneznou
		$prevodnik['nemovitost_uir_okres_kod'][3608] = 10083608; // Semily
		$prevodnik['nemovitost_uir_okres_kod'][3609] = 10043609; // Svitavy
		$prevodnik['nemovitost_uir_okres_kod'][3610] = 10053610; // Trutnov
		$prevodnik['nemovitost_uir_okres_kod'][3611] = 10043611; // Usti nad Orlici
		$prevodnik['nemovitost_uir_okres_kod'][3701] = 20023701; // Blansko
		$prevodnik['nemovitost_uir_okres_kod'][3702] = 20023702; // Brno-mesto
		$prevodnik['nemovitost_uir_okres_kod'][3703] = 20023703; // Brno-venkov
		$prevodnik['nemovitost_uir_okres_kod'][3704] = 20023704; // Breclav
		$prevodnik['nemovitost_uir_okres_kod'][3705] = 20143705; // Zlin
		$prevodnik['nemovitost_uir_okres_kod'][3706] = 20023706; // Hodonin
		$prevodnik['nemovitost_uir_okres_kod'][3707] = 10063707; // Jihlava
		$prevodnik['nemovitost_uir_okres_kod'][3708] = 20143708; // Kromeriz
		$prevodnik['nemovitost_uir_okres_kod'][3709] = 20093709; // Prostejov
		$prevodnik['nemovitost_uir_okres_kod'][3710] = 10063710; // Trebic
		$prevodnik['nemovitost_uir_okres_kod'][3711] = 20143711; // Uherske Hradiste?
		$prevodnik['nemovitost_uir_okres_kod'][3712] = 20023712; // Vyskov
		$prevodnik['nemovitost_uir_okres_kod'][3713] = 20023713; // Znojmo
		$prevodnik['nemovitost_uir_okres_kod'][3714] = 10063714; // Zdar nad Sazavou
		$prevodnik['nemovitost_uir_okres_kod'][3801] = 20123801; // Bruntal
		$prevodnik['nemovitost_uir_okres_kod'][3802] = 20123802; // Frydek-Mistek
		$prevodnik['nemovitost_uir_okres_kod'][3803] = 20123803; // Karvina
		$prevodnik['nemovitost_uir_okres_kod'][3804] = 20123804; // Novy Jicin
		$prevodnik['nemovitost_uir_okres_kod'][3805] = 20093805; // Olomouc
		$prevodnik['nemovitost_uir_okres_kod'][3806] = 20123806; // Opava
		$prevodnik['nemovitost_uir_okres_kod'][3807] = 20123807; // Ostrava-mesto
		$prevodnik['nemovitost_uir_okres_kod'][3808] = 20093808; // Prerov
		$prevodnik['nemovitost_uir_okres_kod'][3809] = 20093809; // ҆umperk
		$prevodnik['nemovitost_uir_okres_kod'][3810] = 20143810; // Vset??n
		$prevodnik['nemovitost_uir_okres_kod'][3811] = 20093811; // Jesen??k
		$prevodnik['nemovitost_uir_okres_kod'][1] = 10013101; // Praha 1
		$prevodnik['nemovitost_uir_okres_kod'][2] = 10013102; // Praha 2
		$prevodnik['nemovitost_uir_okres_kod'][3] = 10013103; // Praha 3
		$prevodnik['nemovitost_uir_okres_kod'][4] = 10013104; // Praha 4
		$prevodnik['nemovitost_uir_okres_kod'][5] = 10013105; // Praha 5
		$prevodnik['nemovitost_uir_okres_kod'][6] = 10013106; // Praha 6
		$prevodnik['nemovitost_uir_okres_kod'][7] = 10013107; // Praha 7
		$prevodnik['nemovitost_uir_okres_kod'][8] = 10013108; // Praha 8
		$prevodnik['nemovitost_uir_okres_kod'][9] = 10013109; // Praha 9
		$prevodnik['nemovitost_uir_okres_kod'][10] = 10013110; // Praha 10

		return $prevodnik;
	}

}