<?php
/**
 * Převodník adres z UIR do FSU. Používá databázovou třídu z Irestu 1.
 *
 * Jak to funguje? Skoro celá adresa se nyní zadává pomocí UIR ADR. Jedinná část,
 * která se nadále posílá v FSU je katastrální území, které se odvodí z tabulky realitycz_cobce2ku.
 *
 * Starý výběrníček jde tím pádem do kopru.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_RealityCz_Irest2 implements Dalten_AddressConverter_RealityCz_Interface
{
	private $_repository;

	/**
	 * Konstruktor. Nastavuje závislosti.
	 *
	 * @param Irest\Persistence\Repository\Address $repository Adresní repozitář z Irestu2.
	 *                                                         Práci s databazí dělá on.
	 */
	function __construct(\Irest\Persistence\Repository\Address $repository)
	{
		$this->_repository = $repository;
	}

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		$input['nemovitost_ku_kod'] = $this->_repository->getCadastralAreaFromMunicipalityPart(
			$input['nemovitost_uir_cobce_kod']
		);
		return $input;
	}
}
