<?php
class Dalten_Export_Idnes2 extends Dalten_Export_Idnes
{
	/**
	 * {@inheritdocs}
	 */
	protected function _convert(array $convertedValues, array $originalValues, $entityName)
	{
		$convertedValues =  parent::_convert($convertedValues, $originalValues, $entityName);

		// var_dump(array('ukod'=>$originalValues['nemovitost_uir_ulice_kod']));

		// nastavujeme novou adresu
        if ($originalValues['nemovitost_uir_stat']=='CZ') {
            $convertedValues['ruian_kod_obce'] = $originalValues['nemovitost_uir_obec_kod'];
            $convertedValues['ruian_kod_casti_obce'] = $originalValues['nemovitost_uir_cobce_kod'];
            $convertedValues['ruian_kod_ulice'] = $originalValues['nemovitost_uir_ulice_kod'];
        } else {
            $statPrevod = $this->_getCiselnikStatu();
            $convertedValues['f_stat'] = $statPrevod[$originalValues['nemovitost_uir_stat']];
            $convertedValues['oblast'] = $originalValues['nemovitost_uir_kraj_text'];
            $convertedValues['obec'] = $originalValues['nemovitost_uir_obec_text'];
        }

		// uklízíme starou
		unset($convertedValues['obec_cast'], $convertedValues['id_cast'], $convertedValues['ulice'], $convertedValues['ulice_nr']);

		if (isset($this->_additionalParams['listing']['f_rozostreni']) && isset($this->_additionalParams['listing']['b_show_map'])) {
			// Když bude uloženo nastavení na kartě exporty, bude se idnes chovat přímo tak, jak určuje nastavení na kartě exporty
			$convertedValues['f_rozostreni'] = $this->_additionalParams['listing']['f_rozostreni'];
			$convertedValues['b_show_map'] = $this->_additionalParams['listing']['b_show_map'];
		} else {
            /*
                 Když není uloženo nastavení na kartě exporty, nastavuje se rozostření podle převodníku (irest » idnes):
                    zobrazit přesně » ulice
                    znepřesnit o jednu » část obce
                    znepřesnit o dvě » obec
                S tím, že pokud bude nastaveno znepřesnění jiné než "zobrazit přesně"/"ulice" a zadáno GPS,
                pošleme nezobrazovat mapu (protože idnes neumí znepřesňovat GPS).
             */

            $convertedValues['f_rozostreni'] = !empty($originalValues['nabidka_gps_presnost']) ? $originalValues['nabidka_gps_presnost'] : 1;
            $convertedValues['b_show_map'] = 0;
            if ($convertedValues['f_rozostreni'] == 1) {
                $convertedValues['b_show_map'] = 1;
            }
        }

        if (!empty($originalValues['videos'])) {
            $convertedValues['videos'] = $originalValues['videos'];
        }

		return $convertedValues;
	}

    protected function _getCiselnikStatu()
    {
        // tyto neumíme přeložit:
        // BL = Saint-Barthélemy ?
        // MF = Saint-Martin ?
        // ST = Svatý Tomáš a Princův ostrov ?
        return
            array (
                'AX' => 74,
                'BN' => 30,
                'TF' => 78,
                'GS' => 71,
                'KR' => 117,
                'NL' => 151,
                'PS' => 83,
                'PG' => 170,
                'PN' => 174,
                'PM' => 189,
                'KP' => 116,
                'ST' => 192,
                'SJ' => 209,
                'LK' => 41,
                'VA' => 98,
                'AF' => 1,
                'AL' => 2,
                'DZ' => 4,
                'AS' => 5,
                'VI' => 236,
                'AD' => 6,
                'AO' => 7,
                'AI' => 187,
                'AQ' => 3,
                'AG' => 8,
                'AR' => 10,
                'AM' => 16,
                'AW' => 153,
                'AU' => 11,
                'AZ' => 9,
                'BS' => 13,
                'BH' => 14,
                'BD' => 15,
                'BB' => 17,
                'BE' => 18,
                'BZ' => 26,
                'BY' => 34,
                'BJ' => 59,
                'BM' => 19,
                'BT' => 20,
                'BO' => 21,
                'BA' => 22,
                'BW' => 23,
                'BV' => 24,
                'BR' => 25,
                'IO' => 27,
                'VG' => 29,
                'BG' => 31,
                'BF' => 237,
                'BI' => 33,
                'CK' => 53,
                'TD' => 42,
                'ME' => 143,
                'CN' => 44,
                'DK' => 60,
                'DM' => 61,
                'DO' => 62,
                'DJ' => 79,
                'EG' => 229,
                'EC' => 63,
                'ER' => 67,
                'EE' => 68,
                'ET' => 66,
                'FO' => 69,
                'FK' => 70,
                'FJ' => 72,
                'PH' => 173,
                'FI' => 73,
                'FR' => 75,
                'GF' => 76,
                'PF' => 77,
                'GA' => 80,
                'GM' => 82,
                'GH' => 85,
                'GI' => 86,
                'GD' => 90,
                'GL' => 89,
                'GE' => 81,
                'GP' => 91,
                'GU' => 92,
                'GT' => 93,
                'GN' => 94,
                'GW' => 177,
                'GG' => 231,
                'GY' => 95,
                'HT' => 96,
                'HM' => 97,
                'HN' => 99,
                'HK' => 100,
                'CL' => 43,
                'HR' => 55,
                'IN' => 103,
                'ID' => 104,
                'IQ' => 106,
                'IR' => 105,
                'IE' => 107,
                'IS' => 102,
                'IT' => 109,
                'IL' => 108,
                'JM' => 111,
                'JP' => 112,
                'YE' => 243,
                'JE' => 232,
                'ZA' => 203,
                'JO' => 114,
                'KY' => 39,
                'KH' => 35,
                'CM' => 36,
                'CA' => 37,
                'CV' => 38,
                'QA' => 180,
                'KZ' => 113,
                'KE' => 115,
                'KI' => 87,
                'CC' => 47,
                'CO' => 48,
                'KM' => 49,
                'CG' => 52,
                'CR' => 54,
                'CU' => 56,
                'KW' => 118,
                'CY' => 57,
                'KG' => 119,
                'LA' => 120,
                'LS' => 122,
                'LB' => 121,
                'LR' => 124,
                'LY' => 125,
                'LI' => 126,
                'LT' => 127,
                'LV' => 123,
                'LU' => 128,
                'MO' => 129,
                'MG' => 130,
                'HU' => 101,
                'MK' => 228,
                'MY' => 132,
                'MW' => 131,
                'MV' => 133,
                'ML' => 134,
                'MT' => 135,
                'IM' => 233,
                'MA' => 145,
                'MH' => 166,
                'MQ' => 136,
                'MU' => 138,
                'MR' => 137,
                'YT' => 50,
                'UM' => 164,
                'MX' => 139,
                'FM' => 165,
                'MD' => 142,
                'MC' => 140,
                'MN' => 141,
                'MS' => 144,
                'MZ' => 146,
                'MM' => 32,
                'NA' => 148,
                'NR' => 149,
                'DE' => 84,
                'NP' => 150,
                'NE' => 158,
                'NG' => 159,
                'NI' => 157,
                'NU' => 160,
                'AN' => 152,
                'NF' => 161,
                'NO' => 162,
                'NC' => 154,
                'NZ' => 156,
                'OM' => 147,
                'PK' => 168,
                'PW' => 167,
                'PA' => 169,
                'PY' => 171,
                'PE' => 172,
                'CI' => 110,
                'PL' => 175,
                'PR' => 179,
                'PT' => 176,
                'AT' => 12,
                'RE' => 181,
                'GQ' => 65,
                'RO' => 182,
                'RU' => 183,
                'RW' => 184,
                'GR' => 88,
                'SV' => 64,
                'WS' => 242,
                'SM' => 191,
                'SA' => 193,
                'SN' => 194,
                'MP' => 163,
                'SC' => 196,
                'SL' => 197,
                'SG' => 198,
                'SK' => 199,
                'SI' => 201,
                'SO' => 202,
                'AE' => 220,
                'GB' => 230,
                'US' => 235,
                'RS' => 195,
                'CF' => 40,
                'SD' => 207,
                'SR' => 208,
                'SH' => 185,
                'LC' => 188,
                'KN' => 186,
                'VC' => 190,
                'SZ' => 210,
                'SY' => 213,
                'SB' => 28,
                'ES' => 205,
                'SE' => 211,
                'CH' => 212,
                'TJ' => 214,
                'TZ' => 234,
                'TH' => 215,
                'TW' => 45,
                'TG' => 216,
                'TK' => 217,
                'TO' => 218,
                'TT' => 219,
                'TN' => 221,
                'TR' => 222,
                'TM' => 223,
                'TC' => 224,
                'TV' => 225,
                'UG' => 226,
                'UA' => 227,
                'UY' => 238,
                'UZ' => 239,
                'CX' => 46,
                'VU' => 155,
                'VE' => 240,
                'VN' => 200,
                'TL' => 178,
                'WF' => 241,
                'ZM' => 244,
                'EH' => 206,
                'ZW' => 204,
            );
    }

}
