<?php

/**
 * Abstraktní runner združující spolčné prvky Runnerů.
 */
abstract class Dalten_Export_AbstractRunner
{
	/**
	 * Instance factory na exportní API.
	 *
	 * @var Irest_Export_Factory
	 */
	protected $_factory;

	/**
	 * Instance loggeru, používaného na exporty.
	 *
	 * @var Dalten_Export_Api_Backend_Logger_LoggerInterface
	 */
	protected $_logger = null;

	/**
	 * Doba (v sekundách) po kterou může export maximálně běžet než je spuštěn znovu.
	 *
	 * @var int
	 */
	protected $_maxRunningTime = 1200;

	/**
	 * Konstruktor. Nastavuje závislosti třídy.
	 *
	 * @param Irest_Export_Factory $exporterFactory Fabrika na jednotlivé exportovací syncovací API.
	 */
	public function __construct(Irest_Export_Factory $exporterFactory)
	{
		$this->_factory = $exporterFactory;
	}

	/**
	 * Spustí činnost runnera.
	 *
	 * @param Zend_Console_Getopt $arguments
	 */
	abstract public function run(Zend_Console_Getopt $arguments);

	/**
	 * Vrátí přidané parametry pro daný export. Vrácené pole bude použito do metody openConnection.
	 *
	 * Prozatím neimplementováno.
	 *
	 * @param array $login Nastavení exportu (řádek z tabulky exports_login).
	 *
	 * @return array Přidané nastavení pro daný server (prozatím jen prázdné pole).
	 */
	protected function _getAdditionalParamsForExportType(array $login)
	{
		return array();
	}

	/**
	 * Nastaví logger na exporty.
	 *
	 * Logger bude použit pouze pokud to daná exportní api podporuje.
	 *
	 * @param Dalten_Export_Api_Backend_Logger_LoggerInterface $logger Instance exportního loggeru.
	 *
	 * @return Irest_Export_Runner Fluent interface.
	 */
	public function setLogger(Dalten_Export_Api_Backend_Logger_LoggerInterface $logger)
	{
		$this->_logger = $logger;

		return $this;
	}

	/**
	 * Vrací definice defaultních pravidel pro Zend_Console_Getopt.
	 *
	 * @return array Pole defaultních pravidel pro Zend_Console_Getopt.
	 *
	 * @static
	 */
	public static function getDefaultGetoptRules()
	{
		return array(
			'types|t=s' => 'Export types to be processed (comma separated numbers)',
			'companies|c=s' => 'Companies to be exported (comma separated IDs)',
			'log|l' => 'Log output?'
		);
	}
}
