<?php

/**
 * Jednoduchý logger, který ukládá data do souboru.
 *
 * Použitelné pro debugování věcí co se volají přes AJAX.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Backend
 */
class Dalten_Export_Api_Backend_Logger_FileEcho implements Dalten_Export_Api_Backend_Logger_LoggerInterface
{
    protected $_file;

    public function __construct($_file)
    {
        $this->_file = $_file;
        file_put_contents($_file, '');
    }


    protected function echo($text)
    {
        file_put_contents($this->_file, $text . PHP_EOL, FILE_APPEND);
    }

	/**
	 * Zaloguje volání vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName Název volané metody.
	 * @param mixed  $data       Data se kterými je metoda volána.
	 */
	public function logRemoteCall($methodName, $data)
	{
		$this->echo('METHOD CALL: ' . $methodName . ' called @ ' . date('j.n.Y H:i:s'), PHP_EOL);
		$this->echo('METHOD DATA: ' . PHP_EOL . print_r($data, true));
		$this->echo(PHP_EOL . '==========' . PHP_EOL . PHP_EOL);
	}

	/**
	 * Zaloguje odpověď vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName  Název volané metody.
	 * @param mixed  $reponseData Odpověď serveru.
	 */
	public function logRemoteResponse($methodName, $reponseData)
	{
		$this->echo('SERVER RESPONSE: ' . $methodName . ' retrieved @ ' . date('j.n.Y H:i:s') . PHP_EOL);
		$this->echo('RESPONSE DATA  :' . PHP_EOL . print_r($reponseData, true));
		$this->echo(PHP_EOL . '==========' . PHP_EOL . PHP_EOL);
	}
}
