<?php
/**
 * Exportní API serveru UlovDomov. Opravuje chování rozhraní u Srealitích klonů.
 *
 * Jenom lehce pozměňuje chování exportního API Srealit.
 *
 * @see Dalten_Export_Api_Sreality
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_UlovDomov extends Dalten_Export_Api_Sreality
{
    /**
     * Vyexportuje uživatele. Jako sreality_login podstrkává email uživatele.
     *
     * @param array $userData Data uživatele ve formátu iRest 1.
     *
     * @see Dalten_Export_Api_Sreality::addUser
     *
     * @return Dalten_Export_Api_ServerResponse Odpověď serveru, jestli se export podařil nebo co selhalo.
     */
    public function addUser(array $userData)
    {
        $userData['sreality_login'] = $userData['email'];
        return parent::addUser($userData);
    }

}
