<?php
/**
 * Statický převodník pro Hyperreality. Číselníky má zadrátované v sobě.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_Hyperreality_Static implements Dalten_AddressConverter_Hyperreality_Interface
{
	/**
	 * Vrací zadrátovaný číselník pro převod Městské části na správní obvod.
	 *
	 * @return array Zadrátovaný číselník.
	 */
	protected static function _getSobvodPrevodnik()
	{
		//
		$sobvodTable = <<<SOBVOD
547310;221;Praha-Čakovice
547361;141;Praha 14
547107;124;Praha 12
547174;213;Praha 17
500089;27;Praha 2
500054;19;Praha 1
500178;60;Praha 6
500216;94;Praha 9
500097;35;Praha 3
539635;132;Praha-Řeporyje
539791;116;Praha-Újezd
547051;124;Praha-Libuš
547271;60;Praha-Suchdol
547298;86;Praha-Ďáblice
500224;108;Praha 10
539724;116;Praha-Šeberov
538302;183;Praha-Klánovice
539694;132;Praha 13
547301;86;Praha-Dolní Chabry
547395;159;Praha-Petrovice
538078;191;Praha-Benice
547417;221;Praha 18
538361;191;Praha-Kolovraty
547034;116;Praha 11
538124;86;Praha-Březiněves
538400;116;Praha-Křeslice
538531;191;Praha-Nedvězí
539465;205;Praha-Lochkov
547158;60;Praha-Nebušice
547328;78;Praha-Troja
500186;78;Praha 7
547379;159;Praha-Dolní Měcholupy
547409;159;Praha-Štěrboholy
547115;205;Praha-Velká Chuchle
538175;141;Praha-Dolní Počernice
539864;205;Praha-Zbraslav
539678;51;Praha-Slivenec
539007;167;Praha-Vinoř
538388;191;Praha-Královice
547042;43;Praha-Kunratice
547387;159;Praha 15
500119;43;Praha 4
547344;167;Praha 19
500143;51;Praha 5
538213;175;Praha 20
539589;60;Praha-Přední Kopanina
538353;183;Praha-Koloděje
538060;183;Praha-Běchovice
539449;205;Praha-Lipence
500208;86;Praha 8
538205;159;Praha-Dubeč
538931;191;Praha 22
547140;60;Praha-Lysolaje
539899;213;Praha-Zličín
538736;167;Praha-Satalice
538949;183;Praha 21
539601;205;Praha 16
539601;205;Praha 16
SOBVOD;
		$sobvody = array();
		foreach (explode("\n", $sobvodTable) as $row) {
			list($mcast_id, $sobvod_id) = explode(';', $row);
			$sobvody[intval($mcast_id)] = intval($sobvod_id);
		}
		return $sobvody;

	}

	/**
	 * Převede kód městské části na kód správního obvodu.
	 *
	 * @param int $mcast_kod Kód městské části.
	 *
	 * @return mixed Kód správního obvodu.
	 */
	protected function _getSobvodCode($mcast_kod)
	{
		$sobvodCiselnik = self::_getSobvodPrevodnik();
		return $sobvodCiselnik[$mcast_kod];
	}

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		if ($input['nemovitost_uir_mcast_kod']) {
			$input['cityverge_id'] = $this->_getSobvodCode($input['nemovitost_uir_mcast_kod']);
		}
		return $input;
	}
}