<?php
/**
 * Převodník adres z UIR do extended RUIAN.
 *
 * Podle typu nemovitosti dopočítá RUIAN kód adresy s fallbackem
 * na starý způsob zadávání (pokud je adresa nepřesná).
 *
 * Tj.hledá ruian_adresa_kod.
 * 
 * Tato verze NEpodporuje sdružená Č.P.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_RealityCz_Irest1Ruian implements Dalten_AddressConverter_RealityCz_Interface
{
	private $_db;

	/**
	 * Konstruktor. Nastavuje databázi.
	 *
	 * @param Irest_Database $db Prihlasena adresni databaze.
	 *
	 * @throws Exception Když se nedostane do adresní databáze.
	 */
	function __construct(Irest_Database $db)
	{
		if (!$db->getConnection()) {
			throw new Exception('Prevodniku adres musite predat platne pripojeni do adresni databaze.');
		}
		$this->_db = $db;
	}

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		// když nemáme KU kód, zkusíme ho dopočítat
		if (empty($input['nemovitost_ku_kod'])) {
			$input['nemovitost_ku_kod'] = $this->_db->fetchField(
				sprintf(
					'SELECT ku_kod FROM realitycz_cobce2ku WHERE cobce_kod=%d',
					$input['nemovitost_uir_cobce_kod']
				)
			);
		}

		// když je parcela
		if ($input['nemovitost_typ']==3) {
			// TODO - toto zakomentovat a/nebo zjistit, proč nejsou všechny parcely v našem RUIANU
			// měl jsem testovací parcelu v Rudné u Phy a kde nic, tu nic

			// zkusíme najít kód parcely
			// (musím mít katastrální uzemí a číslo parcely)
			/*
			if (
				!empty($input['nemovitost_ku_kod']) &&
				!empty($input['nemovitost_parcela_cislo']) &&
				$input['nemovitost_parcela_typ']==1 // (musí být parcela z katastru, jinak nemá kód parcely)
			) {
				$subCisloPodminka = '';
				if (!empty($input['nemovitost_parcela_subcislo'])) {
					$subCisloPodminka = sprintf(' AND pododdeleni_cisla=%d', $input['nemovitost_parcela_subcislo']);
				}
				$parcelaKod = $this->_db->fetchField(
					sprintf(
						'SELECT parcela_kod FROM parcela WHERE druh_cislovani=%d AND ku_kod=%d AND kmenove_cislo=%d' . $subCisloPodminka,
						$input['nemovitost_parcela_druh_cislovani'],
						$input['nemovitost_ku_kod'],
						$input['nemovitost_parcela_cislo']
					)
				);
				if ($parcelaKod) {
					// našli jsme parcelu
					$input['ruian_parcela_kod'] = $parcelaKod;
					$input['nemovitost_ku_kod'] = 0; // vynulujeme
				}

			}
			*/
		// když není parcela
		} else {
			// zkusíme najít jako adresní bod
			// (musím mít Č.P. a část obce)
			if (!empty($input['nemovitost_uir_cobce_kod']) && !empty($input['nemovitost_uir_cp'])) {

				// zkusíme získat stavební objekt
				$objektKod = $this->_db->fetchField(
					sprintf(
						'SELECT objekt_kod FROM objekt WHERE stav=1 AND cisdom_typ=1 AND cobce_kod=%d AND cisdom_hod=%d',
						$input['nemovitost_uir_cobce_kod'],
						$input['nemovitost_uir_cp']
					)
				);

				if ($objektKod) {
					// když máme stavební objekt, hledáme adresu
					$coPodminka = ' AND cisor_hod IS NULL'; // nevyplněné č.o. » ptáme se jen na adresy, co ho nemají
					if (!empty($input['nemovitost_uir_co'])) {
						// pokud máme číslo orientační,  rozdělujeme č.o. na číselnou část a písmeno na konci
						$castiCO = array();
						preg_match('~(\d+)([[:alpha:]]?)~', $input['nemovitost_uir_co'], $castiCO);
						$coPodminka = sprintf(' AND cisor_hod=%d', $castiCO[1]);
						if (!empty($castiCO[2])) {
							$coPodminka .=  ' AND cisor_pis='. $this->_db->quoteParam($castiCO[2]) .'';
						} else {
							$coPodminka .= ' AND cisor_pis IS NULL';
						}
					}

					$adresaKod = $this->_db->fetchField(
						sprintf(
							'SELECT adresa_kod FROM adresa WHERE stav=1 AND objekt_kod=%d ' . $coPodminka,
							$objektKod
						)
					);

					if ($adresaKod) {
						// našli jsme adresu
						$input['ruian_adresa_kod'] = $adresaKod;
						$input['nemovitost_ku_kod'] = 0; // vynulujeme
					}
				}
			}
		}

		return $input;
	}
}