<?php
class Dalten_Export_Api_Backend_Ingatlannethu{
	private $_export=null;
	private $_config=null;

	public function __construct(Dalten_Export_Ingatlannethu $export, Serenity_Config_Config $config){
		$this->_export=$export;
		$this->_config=$config;
	}

	public function prepareXml(){
		$xml=new Dalten_Xml_SimpleXml('<?xml version="1.0" encoding="UTF-8"?><properties/>');
		return $xml;
	}


	public function appendProperty($xml, $data, $user, $images, $additionalParameters=array()){
		$propertyNode=$xml->addChild('property');
		$this->appendSection($propertyNode, $data, 'property');
		$this->appendSection($propertyNode->addChild('descriptions')->addChild('description'), $data, 'description');
		$this->appendSection($propertyNode->addChild('agent'), $user, 'agent');
		//TODO vyřešit údaje kanceláře ve frontendu (_api) údaje kanceláře z nastavení ($additionalParameters)
		$this->appendSection($propertyNode->addChild('office'), $user, 'office');

		if (count($images)>1){
			$picturesNode=$propertyNode->addChild('pictures');
			foreach ($images as $image){
				$picture=$picturesNode->addChild('picture');
				$picture->addChild('picture_url')->addCDATA($image['url']);
			}
		}

		//return $xml->saveXML();
	}

	private function appendSection(Dalten_Xml_SimpleXml $node, $rawData, $part){
		$converted = $this->_export->convertEntityValues($part,$rawData,$this->_config->$part);
		foreach ($converted as $dataKey=>$dataValue){
			if (is_string($dataValue) and !isset($this->_config->$part->$dataKey->noCDATA)){
				$node->addChild($dataKey)->addCDATA($dataValue);
			}else{
				//Akceptují boolovské hodnoty jen slovy
				if ($dataValue===true){
					$dataValue='true';
				}
				if ($dataValue===false){
					$dataValue='false';
				}
				$node->addChild($dataKey, $dataValue);
			}
		}

	}

	public function saveToFile(Dalten_Xml_SimpleXml $xml, $fileName){
		return $xml->saveXML($fileName);
	}
}