<?php

/**
 * Rozhraní pro API exportů, které umožňují exportovat developerské projekty.
 * Formát předávaných dat je vždy iRest 1.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
interface Dalten_Export_Api_ProjectApiInterface
{
	/**
	 * Vyexportuje projekt.
	 *
	 * @param array $projectData      Data projektu ve formátu iRest 1.
	 * @param array $userData         Data uživatele (makléře, kterému projekt patří) ve formátu iRest 1.
	 * @param array $listingIds       Pole s IDčky nabídek (ve tvaru id=>kod).
	 * @param array $images           Pole fotografií projektu ve formátu iRest 1.
	 * @param array $additionalParams Údaje které vrací server při exportu a jsou potřeba pro další práci s nabídkou.
	 *                                Data můžou sloužit pro editaci apod...
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru, jestli se export podařil nebo co selhalo.
	 */
	public function addProject(array $projectData, array $userData, array $listingIds = array(),
		array $images = array(), array $additionalParams = array());

	/**
	 * Odstraní projekt ze vzdáleného serveru.
	 *
	 * @param array $projectData      Data projektu ve formátu iRest 1.
	 * @param array $additionalParams Specifická data pro daný export.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function deleteProject(array $projectData, array $additionalParams = array());
}
