<?php
/**
 * Odpověď serveru obohacená o ověřování.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_ServerResponseVerifiable extends Dalten_Export_Api_ServerResponse
{
	const IN_PROGRESS = -1;
	const VERIFIED = 1;
	const NOT_VERIFIED = 0;

	private $_verificationStatus = self::IN_PROGRESS;

	/**
	 * Nastavuje stav ověřovaní.
	 *
	 * @param bool      $verificationDone Zda už ověřování proběhlo.
	 * @param null|bool $isVerified       Zda je ověřeno, nebo null pokud ověřování ještě neproběhlo.
	 *
	 * @throws Exception Pokud se programátor snaží podstrčit špatnou kombinaci argumentů.
	 */
	public function setVerificationStatus($verificationDone, $isVerified = null)
	{
		if ($verificationDone && is_null($isVerified)) {
			throw new Exception('Unknown status of verification!');
		}

		if ($verificationDone) {
			if ($isVerified) {
				$this->_verificationStatus = self::VERIFIED;
			} else {
				$this->_verificationStatus = self::NOT_VERIFIED;
			}
		} else {
			$this->_verificationStatus = self::IN_PROGRESS;
		}
	}

	/**
	 * Běží ještě ověřovaní?
	 *
	 * @return bool Vrací zda ano či ne.
	 */
	public function verificationInProgress()
	{
		return (($this->_verificationStatus == self::IN_PROGRESS) ? true : false);
	}

	/**
	 * Podařilo se údaje ověřit?
	 *
	 * @throws Exception Pokud zatím nevíme zda se podařilo ověřit.
	 *
	 * @return bool Zda se podařilo údaje ověřit
	 */
	public function isVerified()
	{
		if ($this->verificationInProgress()) {
			throw new Exception('Verification in progress! Imposible to know if it\'s verified.');
		}
		return (($this->_verificationStatus == self::VERIFIED ? true : false ));
	}
}
