<?php
/**
 * Exportní API pro klony Srealit.
 *
 * Řeší situaci, kdy není jasné, co se má exportovat jako `client_login` makléře tím, že si nechá od spouštěče
 * podstrčit `sreality_like_login` a použije ten.
 *
 * @see Dalten_Export_Api_Sreality
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_SrealityLike extends Dalten_Export_Api_Sreality
{
    protected function _convertUserData(array $userData)
    {
        $converted = parent::_convertUserData($userData);
        $converted['client_login'] = $userData['sreality_like_login'];

        return $converted;
    }

    protected function _translateErrorMessage($statusCode, $statusMessage)
    {
        // Problém - Sreality klony nedordžují úplně na 100% specifikaci chybových hlášek.
        // To může vést k tomu, že chybové hlášky překládáme nesmyslně. Příklad ze života:
        //
        // Eurobydlení vrátí: 466 - Prekrocen denni limit na Insert/Delete (pocet zakazek 53 , export_cnt 100 , export_vyjimka_datum 2019-10-31)
        // my to přeložíme na: Tento server přijímá jen inzeráty s měnou Kč.
        //
        // Proto prozatím pro klony vypínám překládání chybových hlášek.
        return $statusMessage;
    }


}
