<?php
class Dalten_Export_Api_NehnutelnostiSk implements Dalten_Export_Api_ApiInterface, Dalten_Export_Api_LoggableApiInterface
{
	protected $_login = '';
	protected $_apiKey = '';
	/** @var Dalten_Export_Api_Backend_NehnutelnostiSk */
	protected $_backend;

	function __construct(Dalten_Export_Api_Backend_NehnutelnostiSk $backend)
	{
		$this->_backend = $backend;
	}

	/**
	 * Naváže spojení se vzdáleným serverem.
	 *
	 * @param string $login            Přihlašovací jméno.
	 * @param string $password         Heslo.
	 * @param string $softwareKey      Softwarový klíč.
	 * @param array  $additionalParams Pole dalších parametrů.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function openConnection($login, $password, $softwareKey = '', array $additionalParams = array())
	{
		if (empty($additionalParams['klient_id'])) {
			return new Dalten_Export_Api_ServerResponse(false, 'Nebylo předáno klient_id');
		}
		$this->_backend->setLogin($login, $password, $additionalParams['klient_id']);
		return new Dalten_Export_Api_ServerResponse(true);
	}

	/**
	 * Vyexportuje nabídku.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $userData         Data uživatele (makléře, kterému nabídka patří) ve formátu iRest 1.
	 * @param array $images           Pole fotografií nabídky ve formátu iRest 1.
	 * @param array $additionalParams Údaje které vrací server při exportu a jsou potřeba pro další práci s nabídkou.
	 *                                Data můžou sloužit pro editaci apod...
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru, jestli se export podařil nebo co selhalo.
	 */
	public function addListing(array $listingData, array $userData, array $images = array(), array $additionalParams = array())
	{
		if (!empty($additionalParams['listing']['hide_price'])) {
			// Cena dohodou
			$listingData['nemovitost_cena_prodej'] = 0;
			$listingData['nemovitost_cena_pronajem'] = 0;
		}

		$this->_backend->addUser($userData);
		$responseXml = $this->_backend->addListing($listingData, $userData, $images);
		if (is_object($responseXml) && isset($responseXml->status)) {
			return new Dalten_Export_Api_ServerResponse(
				$responseXml->status==200,
				intval($responseXml->status),
				strval($responseXml->data)
			);
		}
		return new Dalten_Export_Api_ServerResponse(false, 500, 'Nastala chyba při exportu nabídky.1');
	}

	/**
	 * Odstraní nabídku ze vzdáleného serveru.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $additionalParams Specifická data pro daný export.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function deleteListing(array $listingData, array $additionalParams = array())
	{
		$listingData['delete'] = true;
		$this->_backend->addListing($listingData, array('id'=>$listingData['id_uzivatel']), array());
		return new Dalten_Export_Api_ServerResponse(true);
	}

	/**
	 * Vrátí seznam nabídek, které jsou na vzdáleném serveru.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function getListingsList()
	{
		throw new BadMethodCallException('not yet implemented');
	}

	/**
	 * Nastaví logger pro backend.
	 *
	 * Logger bude použit pouze pokud to backend dovoluje.
	 *
	 * @param \Dalten_Export_Api_Backend_Logger_LoggerInterface $logger Instance loggeru.
	 *
	 * @return Dalten_Export_Api_LoggableApiInterface Fluent interface.
	 */
	public function setLogger(Dalten_Export_Api_Backend_Logger_LoggerInterface $logger)
	{
		$this->_backend->setLogger($logger);
	}

	/**
	 * Odstraní nastavený logger pro backend.
	 *
	 * @return Dalten_Export_Api_LoggableApiInterface Fluent interface.
	 */
	public function removeLogger()
	{
		$this->_backend->removeLogger();
	}
}