<?php
/**
 * Převodník adres pro Irest 3.
 *
 * Protože Irest 3 dodává ruian_adresa_kod a ruian_parcela_kod, není potřeba nic dohledávat, pouze vynuluje kód KU,
 * když je zadána plná adresa.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_RealityCz_Irest3 implements Dalten_AddressConverter_RealityCz_Interface
{
    /**
     * {@inheritDoc}
     */
    function convertAddress(array $input)
    {
        if (!empty($input['ruian_adresa_kod'])) {
            $input['nemovitost_ku_kod'] = 0; // vynulujeme
        }
        return $input;
    }
}