<?php
/**
 * Export na Topreality.cz. Od exportu na Sreality se liší tím, že neposílá fotografie, pokud se neliší.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_ToprealityCz extends Dalten_Export_Api_SrealityLike
{

	/**
	 * Vyexportuje nabídku.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $userData         Data uživatele (makléře, kterému nabídka patří) ve formátu iRest 1.
	 * @param array $images           Pole fotografií nabídky ve formátu iRest 1.
	 * @param array $additionalParams Pro tento export, nejsou přídavná data potřebná.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru, jestli se export podařil nebo co selhalo.
	 */
	public function addListing(
		array $listingData, array $userData, array $images = array(), array $additionalParams = array()
	)
	{
		$descriptionEn = $this->_findDescriptionTranslation($listingData);
		$priceNoteEn = $this->_findPriceNoteTranslation($listingData);

		$listingData = $this->_export->convertEntityValues('listing', $listingData, $this->_config->listing);

		if (!empty($additionalParams['listing']['hide_price'])) {
			$listingData['advert_price'] = (float) 0;
			$priceNote = isset($listingData['advert_price_text_note'])
				? trim($listingData['advert_price_text_note']) : '';
			if (empty($priceNote)) {
				$listingData['advert_price_text_note'] = 'Informace v RK';
			}
			if (!empty($descriptionEn)) {
				$listingData['advert_price_text_note_en'] = 'Price on request at the office';
			}
		} else {
			if (!empty($priceNoteEn)) {
				$listingData['advert_price_text_note_en'] = (string) $priceNoteEn;
			}
		}

		if (
		isset($listingData['energy_performance_attachment'])
		) {
			$priloha = realpath($listingData['energy_performance_attachment']);
			//nemáme soubor se štítkem (realpath nechá projít prázdnou hodnotu)
			if (empty($listingData['energy_performance_attachment']) || $priloha===false) {
				unset($listingData['energy_performance_attachment']);
			} else {
				$listingData['energy_performance_attachment'] = file_get_contents($listingData['energy_performance_attachment']);
			}
		}

		if (!empty($descriptionEn)) {
			$listingData['description_en'] = $descriptionEn;
		}

		if (!empty($userData)) {
			if (empty($userData['id'])) {
				$userData['id'] = sprintf('%u', crc32(serialize($userData['sreality_login'])));
			}

			$response = $this->addUser($userData);
			if (!$response->wasSuccessful()) {
				return $response;
			}

			$listingData['seller_rkid'] = (string) $userData['id'];
		}

		$warningNote = null;
		$originalResponseCannotModify = null;

		$response = $this->_backend->addAdvert($this->_getSessionId(), $listingData);
		$remoteId = isset($response->output->advertId) ? $response->output->advertId : null;
		if ($response->status != 200) {
			if ($response->status == self::STATUS_CANNOT_MODIFY) {
				$warningNote = 'Inzerát byl přijat, ale změněné povinné položky nebyly uloženy';
				$originalResponseCannotModify = $response->toArray(true);
			}elseif ($response->status == self::STATUS_CANNOT_MODIFY_MAIN){
				return new Dalten_Export_Api_ServerResponse(
					false,
					$response->status,
					'Hlavní položky (typ zakázky, typ nemovitosti a podtyp nemovitosti) již není možné modiﬁkovat protože uplynula doba 3 hodiny od prvního importu.'
				);
			}else{
				return new Dalten_Export_Api_ServerResponse(false, $response->status, $response->statusMessage);
			}
		}

		$remotePhotos = $this->_backend->listPhoto($this->_getSessionId(), null, $listingData['advert_rkid']);
		if ($remotePhotos['output'] instanceof Dalten_Data_ArrayObject) {
			$remotePhotos = $remotePhotos['output']->toArray(true);
		} else {
			$remotePhotos = array();
		}

		if ($this->_comparePhotos($images, $remotePhotos) === false) {
			$this->_deleteImages($listingData['advert_rkid']);
			$response = $this->_addImages($listingData['advert_rkid'], $images);
			if (!$response->wasSuccessful()) {
				return $response;
			}
		}

		$response =  new Dalten_Export_Api_ServerResponse(
			true,
			200,
			((!empty($warningNote)) ? $warningNote : ''),
			array('remoteId' => $remoteId)
		);

		if ($originalResponseCannotModify) {
			$response->setData($originalResponseCannotModify);
		}

		return $response;
	}
}
