<?php
/**
 * {@inheritdoc}
 *
 * Upravená verze exportu na Sreality - navíc má položku youtube_url
 */
class Dalten_Export_VideoBydleni extends Dalten_Export_Sreality
{
    /**
     * {@inheritdoc}
     */
    protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		$convertedValues = parent::_convert($convertedValues, $originalvalues, $entityName);

        if ($entityName=='listing' || $entityName=='project') {
            if ($this->_checkYoutube($originalvalues['nemovitost_virtualni_prohlidka'])) {
                $convertedValues['youtube_url'] = $originalvalues['nemovitost_virtualni_prohlidka'];
            }

            if ($this->_checkYoutube($originalvalues['nemovitost_video_prohlidka'])) {
                $convertedValues['youtube_url'] = $originalvalues['nemovitost_video_prohlidka'];
            }

			if ($convertedValues['locality_uir_level']==11) {
				// posíláme adresní bod, není nutné posílat č.p. a č.o.
				unset($convertedValues['locality_co'], $convertedValues['locality_cp']);
			}
        }
        
		return $convertedValues;
    }
    
    /**
	 * Nechá projít jen URL vedoucí na Youtube.
	 *
	 * @param string $value URL ke kontrole.
	 *
	 * @return string|null Původní URL nebo NULL, pokud nevedla na Youtube.
	 */
	protected function _checkYoutube($value)
	{
        if ($value===null) {
            return null;
        }
		$parsedURL = parse_url($value);
		if (isset($parsedURL['host']) && ($parsedURL['host']=='youtu.be' || $parsedURL['host']=='www.youtube.com' || $parsedURL['host']=='youtube.com')) {
			return $value;
		}
		return null;
	}
}