<?php

class RealityCzTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var Dalten_Export_RealityCz
	 */
	private $export = null;

	/**
	 * @var Serenity_Config_Config
	 */
	private $entities = null;

    private $mockData = array(
		'id' => '1',
		'id_uzivatel' => 56943,
		'id_team' => 1,
		'id_firma' => 1285,
		'id_projekt' => 1,
		'cislo' => '1',
		'kod' => 'N00001',
		'id_klient' => '1',
		'zakazka_typ' => '1',
		'nemovitost_anuita' => '0',
		'nemovitost_anuita_mena' => '0',
		'nemovitost_balkon_plocha' => '0',
		'nemovitost_balkon' => '0',
		'nemovitost_bazen_plocha' => '0',
		'nemovitost_bazen' => '0',
		'nemovitost_bezbarierovy' => '-1',
		'nemovitost_bytu_celkem' => '0',
		'nemovitost_bytu_pocet' => '0',
		'nemovitost_cena_poznamka' => '',
		'nemovitost_cena_prodej' => '1.00',
		'nemovitost_cena_prodej_jednotka' => '1',
		'nemovitost_cena_pronajem' => '12000.00',
		'nemovitost_cena_pronajem_jednotka' => '2',
		'nemovitost_cena_datum_snizeni' => '',
		'nemovitost_charakter_zastavby' => '0',
		'nemovitost_dalsi_nebytove_prostory' => '',
		'nemovitost_datum_nastehovani' => '0000-00-00',
		'nemovitost_delka' => '0',
		'nemovitost_dispozice' => '1',
		'nemovitost_doprava' => '0001',
		'nemovitost_druh_bytu' => '0',
		'nemovitost_druh_objektu' => '3',
		'nemovitost_druh_pozemku' => '0',
		'nemovitost_druh_prostor' => '0',
		'nemovitost_druh_stavby' => '0',
		'nemovitost_elektrina' => '0101',
		'nemovitost_garaz_plocha' => '0',
		'nemovitost_garaz' => '-1',
		'nemovitost_parkovaci_stani' => '-1',
		'nemovitost_parkovaci_stani_plocha' => '0',
		'nemovitost_inzenyrske_site' => '',
		'nemovitost_komunikace' => '0',
		'nemovitost_konstrukcni_prvky' => '',
		'nemovitost_lodzie_plocha' => '0',
		'nemovitost_lodzie' => '1',
		'nemovitost_makler_poznamka' => '',
		'nemovitost_mena' => '1',
		'nemovitost_obcanska_vybavenost' => '',
		'nemovitost_odpad' => '01',
		'nemovitost_ostatni' => '',
		'nemovitost_ostatni_nebytove_prosotry_popis' => '',
		'nemovitost_ostatni_rozvody' => '',
		'nemovitost_parcela_typ' => '5',
		'nemovitost_parcela_druh_cislovani' => '8',
		'nemovitost_parcela_cislo' => '694',
		'nemovitost_parcela_subcislo' => '15E57R',
		'nemovitost_ostatni_vybavenost' => '',
		'nemovitost_plocha_celkova' => '80',
		'nemovitost_plocha_dalsi_nebytove_prostory' => '0',
		'nemovitost_plocha_dalsi_zelene' => '0',
		'nemovitost_plocha_dilna' => '0',
		'nemovitost_plocha_dilny' => '0',
		'nemovitost_plocha_jine' => '0',
		'nemovitost_plocha_jine_popis' => '',
		'nemovitost_plocha_kancelari' => '0',
		'nemovitost_plocha_nebytovych_prostor' => '0',
		'nemovitost_plocha_nejmensi' => '0',
		'nemovitost_plocha_nejvetsi' => '0',
		'nemovitost_plocha_obchodni' => '0',
		'nemovitost_plocha_obchodu' => '0',
		'nemovitost_plocha_obestavena' => '0',
		'nemovitost_plocha_parcely' => '0',
		'nemovitost_plocha_provozni' => '0',
		'nemovitost_plocha_skladu' => '0',
		'nemovitost_plocha_terasa' => '0',
		'nemovitost_plocha_uzitna' => '0',
		'nemovitost_plocha_uzitna_podkrovi' => '0',
		'nemovitost_plocha_uzitna_prizemi' => '0',
		'nemovitost_plocha_vnejsich_komunikaci' => '0',
		'nemovitost_plocha_vyrobni' => '0',
		'nemovitost_plocha_zahrada' => '0',
		'nemovitost_plocha_zastavena' => '0',
		'nemovitost_plochy_jine_popis' => '',
		'nemovitost_plyn' => '01',
		'nemovitost_pocet_bytu_volnych' => '0',
		'nemovitost_pocet_kancelari' => '0',
		'nemovitost_pocet_luzek' => '0',
		'nemovitost_pocet_mist' => '0',
		'nemovitost_pocet_obchodu' => '0',
		'nemovitost_pocet_podlazi' => '10',
		'nemovitost_pocet_podlazi_pod_zemi' => '0',
		'nemovitost_pocet_volnych_kancelari' => '0',
		'nemovitost_podlazi_cislo' => '2',
		'nemovitost_poloha_objektu' => '0',
		'nemovitost_popis_detailni' => 'popis',
		'nemovitost_popis_zakladni' => 'zakladni popis, musi byt trochu delsi, pac to pak reality.cz neberou.',
		'nemovitost_prodej_vcelku' => '0',
		'nemovitost_pudni_vestavba' => '-1',
		'nemovitost_rok_kolaudace' => '0',
		'nemovitost_rok_rekonstrukce' => '0',
		'nemovitost_rok_vystavby' => '0',
		'nemovitost_schodiste' => '',
		'nemovitost_sirka' => '0',
		'nemovitost_sklep_plocha' => '0',
		'nemovitost_sklep' => '-1',
		'nemovitost_socialni_zarizeni' => '0',
		'nemovitost_socialni_zarizeni_popis' => '',
		'nemovitost_stavba_na_pozemku' => '',
		'nemovitost_stav_objektu' => '2',
		'nemovitost_stromy' => '0',
		'nemovitost_telekomunikace' => '',
		'nemovitost_terasa_plocha' => '0',
		'nemovitost_terasa' => '0',
		'nemovitost_titulek' => 'Pronájem útulné ropné plošiny v Přerově (testovací nabídka)',
		'nemovitost_topeni' => '1000001',
		'nemovitost_typ' => '4',
		'nemovitost_dispozice_bytu' => '1',
		'nemovitost_typ_domu' => '0',
		'nemovitost_typ_zarizeni' => '0',
		'nemovitost_ucel_budovy' => '2',
		'nemovitost_umisteni_objektu' => '0',
		'nemovitost_umisteni_v_chranenych_lokalitach' => '',
		'nemovitost_velikost_bytu' => '',
		'nemovitost_vlastnictvi' => '1',
		'nemovitost_vlastni_pozemek' => '0',
		'nemovitost_voda' => '',
		'nemovitost_vybaveni_byt' => '0',
		'nemovitost_vybaveni_kancelari' => '0',
		'nemovitost_vybaveni_kancelari_popis' => '',
		'nemovitost_vybaveni_komercnich_prostor' => '0',
		'nemovitost_vybaveni_komercnich_prostor_popis' => '',
		'nemovitost_vybaveno' => '1',
		'nemovitost_vybaveno_popis' => '',
		'nemovitost_vyska' => '0',
		'nemovitost_vyska_stropu' => '0',
		'pocet_mist_k_parkovani' => '0',
		'podlazi' => '0',
		'zakazka_datum_editace' => '2010-04-13',
		'zakazka_datum_vlozeno' => '2010-04-13',
		'zakazka_makler' => '0',
		'zakazka_makler_upravil' => '1719',
		'zakazka_stav' => '10',
		'zakazka_typ' => '2',
		'zakazka_obchodovat' => '20',
		'zakazka_obchodovat_provize_castka' => '0.00',
		'zakazka_obchodovat_provize_procenta' => '0.000',
		'zakazka_provize_celkem' => '15000.00',
		'zakazka_provize_procenta' => '107.140',
		'zakazka_provize_typ' => '1',
		'nemovitost_uir_cobce_kod' => '490024',
		'nemovitost_uir_cobce_text' => 'Bubeneč',
		'nemovitost_uir_kraj_kod' => '19',
		'nemovitost_uir_kraj_text' => 'Hlavní město Praha',
		'nemovitost_uir_mcast_kod' => '500178',
		'nemovitost_uir_mcast_text' => 'Praha 6',
		'nemovitost_uir_obec_kod' => '554782',
		'nemovitost_uir_obec_text' => 'Praha',
		'nemovitost_uir_okres_kod' => '3100',
		'nemovitost_uir_okres_text' => 'Hlavní město Praha',
		'nemovitost_uir_pobvod_kod' => '60',
		'nemovitost_uir_pobvod_text' => 'Praha 6',
		'nemovitost_ku_kod' => '730106',
		'nemovitost_ku_nazev' => 'Bubeneč',
		'nemovitost_ku_obec' => '500178',
		'nemovitost_ku_okres' => '3106',
		'nemovitost_uir_ulice_kod' => '480193',
		'nemovitost_uir_ulice_text' => 'Terronská',
		'nemovitost_uir_cp' => '123',
		'nemovitost_uir_co' => '456',
		'nemovitost_uir_stat' => 'CZ',
		'nemovitost_objekt' => '',
		'zakazka_interni_cislo_developera' => '',
		'zakazka_pouzit_foto_projektu' => '0',
		'zakazka_typ_smlouvy' => '20',
		'zakazka_neverejna_poznamka' => '',
		'nemovitost_kauce' => '',
		'smazano' => '0',
		'nabidka_gps_x' => '',
		'nabidka_gps_y' => '',
		'nabidka_gps_presnost' => '-1',
		'zakazka_detail_url' => '',
		'interni_cislo' => 'N666',
		'zakazka_obchodovani_zpusob' => '0111',
		'nabidka_typ_nabidky' => '',
		'preklad_status' => '0',
		'nastaveni_exportu' => ''
	);

    private $user = array(
		'id' => 1,
		'id_firma' => 13,
		'jmeno' => 'frantisek',
		'uzivatel_os_jmeno' => 'Dalten',
		'uzivatel_os_prijmeni' => 'Matlák',
		'telefon' => 'Nokia N8',
		'email' => 'info@dalten.cz',
		'moto' => 'Kdo nekrade, je vůl.',
		'foto' => '/matlak.jpg'
	);

	private $images = array(
		'fikoid.jpg' => array(
			'id' => 1,
			'popis' => 'Foto 1',
			'soubor' => '/fikoid.jpeg'
		),

		'fikoid1.jpg' => array(
			'id' => 2,
			'popis' => 'Foto 2',
			'soubor' => '/fikoid.jpeg'
		)
	);

	/**
	 * @var Dalten_Data_ArrayObject
	 */
	private $_config = array(
		'wsdl' => 'http://soap.reality.cz/',
		'namespace' => 'http://localhost/Do',
		'channel' => 'IREST',
		'channelPass' => 'net-way5',
		'version' => '1.0'
	);

	private $_user = 'ZZZ';
	private $_pass = 'xxxx';

	/**
	 * Přídavná data pro editaci.
	 *
	 * @var array
	 */
	private $_additionalParams = array();

	public function setUp(): void
	{
		$this->_config = new Dalten_Data_ArrayObject($this->_config);

		$iniParser = new Serenity_Config_Parser_Ini();
		$codebooks = new Serenity_Config_Config(CONFIG_PATH . DIRECTORY_SEPARATOR . 'codebooks.ini', $iniParser);
		$this->entities = new Serenity_Config_Config(CONFIG_PATH . DIRECTORY_SEPARATOR . 'reality.cz.ini', $iniParser);

		$this->export = new Dalten_Export_RealityCz($codebooks, $this->entities);
	}

	public function testLogin()
	{
		$backend = new \Dalten_Export_Api_Backend_RealityCz($this->_config);

		$api = new Dalten_Export_Api_RealityCz($this->export, $this->entities, $backend);

		$response = $api->openConnection($this->_user, $this->_pass, null, $this->_additionalParams);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());
	}

	/**
	 * Testování správného určení typu a podtypu nabídky.
	 */
	public function testTypesAndSubTypesConsistency()
	{
		$data = $this->mockData;
		$conf = $this->entities;
		$data['nemovitost_typ'] = 1;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(8, $c['vnDruhNemovitosti0']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = 2;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(16, $c['vnDruhNemovitosti0']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = 3;
		$data['nemovitost_druh_pozemku'] = 1;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(4, $c['vnDruhNemovitosti0']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = 4;
		$data['nemovitost_plocha_celkova'] = 15;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(5, $c['vnDruhNemovitosti0']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = 4;
		$data['nemovitost_plocha_celkova'] = 50;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(6, $c['vnDruhNemovitosti0']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = 4;
		$data['nemovitost_plocha_celkova'] = 90;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(7, $c['vnDruhNemovitosti0']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = 9;
		$data['nemovitost_druh_prostor'] = 3;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(17, $c['vnDruhNemovitosti0']);

		$data = $this->mockData;
		$data['nemovitost_typ'] = 9;
		$data['nemovitost_druh_prostor'] = 1;
		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertEquals(14, $c['vnDruhNemovitosti0']);
	}

	public function testCurrenciesUnits()
	{
		// prodej celek
		$data = $this->mockData;
		$conf = $this->entities;
		$data['zakazka_typ'] = 1;
		$data['nemovitost_cena_prodej'] = 1000000;
		$data['nemovitost_cena_prodej_jednotka'] = 1;

		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertArrayHasKey('Z_CENA_PRODEJE_JEDNOTKA', $c['vsOptionalParameters']);
		$this->assertEquals(2, $c['vsOptionalParameters']['Z_CENA_PRODEJE_JEDNOTKA']);

		// prodej m2
		$data = $this->mockData;
		$conf = $this->entities;
		$data['zakazka_typ'] = 1;
		$data['nemovitost_cena_prodej'] = 1000000;
		$data['nemovitost_cena_prodej_jednotka'] = 3;

		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertArrayHasKey('Z_CENA_PRODEJE_JEDNOTKA', $c['vsOptionalParameters']);
		$this->assertEquals(1, $c['vsOptionalParameters']['Z_CENA_PRODEJE_JEDNOTKA']);

		// prodej celek EUR
		$data = $this->mockData;
		$conf = $this->entities;
		$data['zakazka_typ'] = 1;
		$data['nemovitost_cena_prodej'] = 1000000;
		$data['nemovitost_cena_prodej_jednotka'] = 1;
		$data['nemovitost_mena'] = 3;

		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertArrayHasKey('Z_CENA_PRODEJE_JEDNOTKA', $c['vsOptionalParameters']);
		$this->assertEquals(8, $c['vsOptionalParameters']['Z_CENA_PRODEJE_JEDNOTKA']);

		// pronajem mesic objekt
		$data = $this->mockData;
		$conf = $this->entities;
		$data['zakazka_typ'] = 2;
		$data['nemovitost_cena_pronajem_jednotka'] = 2;
		$data['nemovitost_mena'] = 1;

		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertArrayHasKey('Z_CENA_PRONAJMU_JEDNOTKA', $c['vsOptionalParameters']);
		$this->assertEquals(4, $c['vsOptionalParameters']['Z_CENA_PRONAJMU_JEDNOTKA']);

		// pronajem mes m2 EUR
		$data = $this->mockData;
		$conf = $this->entities;
		$data['zakazka_typ'] = 2;
		$data['nemovitost_cena_pronajem_jednotka'] = 4;
		$data['nemovitost_mena'] = 3;

		$c = $this->export->convertEntityValues('listing', $data, $conf->listing);
		$this->assertArrayHasKey('Z_CENA_PRONAJMU_JEDNOTKA', $c['vsOptionalParameters']);
		$this->assertEquals(14, $c['vsOptionalParameters']['Z_CENA_PRONAJMU_JEDNOTKA']);
	}

	/**
	 * Test exportu nove nabidky.
	 */
	public function testExportListing()
	{
		$backend = new Dalten_Export_Api_Backend_RealityCz($this->_config);
		$api = new Dalten_Export_Api_RealityCz($this->export, $this->entities, $backend);

		$response = $api->openConnection($this->_user, $this->_pass, null, $this->_additionalParams);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());

		foreach ($this->images as $key => $image) {
			$this->images[$key]['soubor'] = realpath(ASSETS_PATH . $image['soubor']);
		}

		// nova nabidka
		$response = $api->addListing($this->mockData, $this->user, $this->images, $this->_additionalParams);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());

		// editace nabidky
		$response = $api->addListing($this->mockData, $this->user, $this->images, $this->_additionalParams);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());

		// smazani nabidky
		$response = $api->deleteListing($this->mockData);
		$this->assertTrue($response->wasSuccessful(), $response->getMessage());
	}

}
