<?php
/**
 * NULL logger, který ve skutečnosti nic neloguje.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Backend
 */
class Dalten_Export_Api_Backend_Logger_Null implements Dalten_Export_Api_Backend_Logger_LoggerInterface
{
	/**
	 * Zaloguje volání vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName Název volané metody.
	 * @param mixed  $data       Data se kterými je metoda volána.
	 */
	public function logRemoteCall($methodName, $data)
	{
		// zarytě mlčí
	}

	/**
	 * Zaloguje odpověď vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName  Název volané metody.
	 * @param mixed  $reponseData Odpověď serveru.
	 */
	public function logRemoteResponse($methodName, $reponseData)
	{
		// zarytě mlčí
	}
}