<?php

/**
 * Zabaluje práci se souborem.
 *
 * Třída má implementované jen některé metody které jsem potřeboval.
 * V případě potřeby si to může každý rozšířit.
 */
class Dalten_File
{
	/**
	 * @var null|resource
	 */
	private $_resource = null;

	/**
	 * Uzavre soubor.
	 */
	public function __destruct()
	{
		if (is_resource($this->_resource)) {
			fclose($this->_resource);
		}
	}

	/**
	 * Otevře soubor v módu.
	 *
	 * Pokud nezadáme filename tak vytvoří v paměti dočasný soubor.
	 *
	 * @param string $filename Název souboru.
	 * @param string $mode     Mód ve kterém chceme soubor otevřít
	 *
	 * @return Dalten_File
	 */
	public function open($filename = '', $mode = 'r+')
	{
		if ($filename === '') {
			$this->_resource = fopen(sprintf('php://%s', 'temp'), $mode);
		} else {
			$this->_resource = fopen($filename, $mode);
		}

		return $this;
	}

	/**
	 * Zapíše do souboru obsah.
	 *
	 * @param string $content Obsah který chceme uložit do souboru.
	 * @return int
	 */
	public function write($content)
	{
		return fwrite($this->_resource, (string) $content);
	}

	/**
	 * Nastaví vnitřní ukazatel souboru na začátek.
	 *
	 * @return bool
	 */
	public function rewind()
	{
		return rewind($this->_resource);
	}

	/**
	 * Vrátí zdroj souboru.
	 *
	 * @return null|resource
	 */
	public function getResource()
	{
		return $this->_resource;
	}
}