<?php
/**
 * Převodník adres z UIR do FSU. Používá databázovou třídu z Irestu 1.
 *
 * Jak to funguje? Skoro celá adresa se nyní zadává pomocí UIR ADR. Jedinná část,
 * která se nadále posílá v FSU je katastrální území, které se odvodí z tabulky realitycz_cobce2ku.
 *
 * Starý výběrníček jde tím pádem do kopru.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_RealityCZ_Irest1 implements Dalten_AddressConverter_RealityCz_Interface
{
	private $_db;

	/**
	 * Konstruktor. Nastavuje databázi.
	 *
	 * @param Irest_Database $db Prihlasena adresni databaze.
	 *
	 * @throws Exception Když se nedostane do adresní databáze.
	 */
	function __construct(Irest_Database $db)
	{
		if (!$db->getConnection()) {
			throw new Exception('Prevodniku adres musite predat platne pripojeni do adresni databaze.');
		}
		$this->_db = $db;
	}

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		$input['nemovitost_ku_kod'] = $this->_db->fetchField(
			sprintf(
				'SELECT ku_kod FROM realitycz_cobce2ku WHERE cobce_kod=%d',
				$input['nemovitost_uir_cobce_kod']
			)
		);

		return $input;
	}

}