<?php

/**
 * Exportní API serveru Sreality.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_Toplakhu implements Dalten_Export_Api_ApiInterface, Dalten_Export_Api_LoggableApiInterface,
	Dalten_Export_Api_CloseableApiInterface
{
	/**
	 * Konvertor hodnot.
	 *
	 * @var Dalten_Export_Sreality
	 */
	private $_export;

	/**
	 * Nastavení.
	 *
	 * @var Serenity_Config_Config
	 */
	private $_config;

	/**
	 * Backend.
	 *
	 * @var Dalten_Export_Api_Backend_Toplakhu
	 */
	private $_backend;

	/**
	 * Konstruktor.
	 *
	 * @param Dalten_Export_Toplakhu             $export  Konvertor hodnot.
	 * @param Serenity_Config_Config             $config  Nastavení.
	 * @param Dalten_Export_Api_Backend_Toplakhu $backend Backend.
	 */
	public function __construct(Dalten_Export_Toplakhu $export,
								Serenity_Config_Config $config,
								Dalten_Export_Api_Backend_Toplakhu $backend)
	{
		$this->_export = $export;
		$this->_config = $config;
		$this->_backend = $backend;
	}

	/**
	 * Naváže spojení se vzdáleným serverem.
	 *
	 * @param string $login            Přihlašovací jméno.
	 * @param string $password         Heslo.
	 * @param string $softwareKey      Softwarový klíč.
	 * @param array  $additionalParams Pole dalších parametrů.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function openConnection($login, $password, $softwareKey = '', array $additionalParams = array())
	{
		$ftp = new Dalten_Ftp_Connector('pokus', 'pokus', 'localhost');
		$this->_backend->setFtpInstance($ftp);
		$this->_backend->open($login['user']);
		return new Dalten_Export_Api_ServerResponse(true);
	}


	/**
	 * Vyexportuje nabídku.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $userData         Data uživatele (makléře, kterému nabídka patří) ve formátu iRest 1.
	 * @param array $images           Pole fotografií nabídky ve formátu iRest 1.
	 * @param array $additionalParams Pro tento export, nejsou přídavná data potřebná.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru, jestli se export podařil nebo co selhalo.
	 */
	public function addListing(
		array $listingData, array $userData, array $images = array(), array $additionalParams = array()
	)
	{
		$adData = $this->_export->convertEntityValues('ad',$listingData, $this->_config->ad);
		$this->_backend->addAd($userData, $adData, $images);
		return new Dalten_Export_Api_ServerResponse(true);
	}

	/**
	 * Odstraní nabídku ze vzdáleného serveru.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $additionalParams Specifická data pro daný export (zde prázdné pole).
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function deleteListing(array $listingData, array $additionalParams = array())
	{
		return new Dalten_Export_Api_ServerResponse(true);
	}

	/**
	 * Zavírá spojení.
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď zda se podařilo zavřít spojení.
	 */
	public function closeConnection()
	{
		$this->_backend->closeAndSend();
		return new Dalten_Export_Api_ServerResponse(true);
	}


	/**
	 * Implementace interface.
	 *
	 * @throws BadMethodCallException
	 */
	public function getListingsList()
	{
		throw new BadMethodCallException("Method 'getListingsList' IS NOT implemented yet.");
	}

	/**
	 * Nastaví logger pro backend.
	 * Logger bude použit pouze pokud to backend dovoluje.
	 *
	 * @param Dalten_Export_Api_Backend_Logger_LoggerInterface $logger Instance loggeru.
	 *
	 * @return bool Podařilo se přiřadit backendu logger?
	 */
	public function setLogger(Dalten_Export_Api_Backend_Logger_LoggerInterface $logger)
	{
		if ($this->_backend instanceof Dalten_Export_Api_Backend_LoggableBackendInterface) {
			$this->_backend->setLogger($logger);

			return true;
		}

		return false;
	}

	/**
	 * Odstraní nastavený logger pro backend.
	 *
	 * @return Dalten_Export_Api_Sreality Fluent interface.
	 */
	public function removeLogger()
	{
		if ($this->_backend instanceof Dalten_Export_Api_Backend_LoggableBackendInterface) {
			$this->_backend->removeLogger();
		}

		return $this;
	}
}
