<?php
/**
 * {@inheritdoc}
 *
 * Testovací verze - odesílá RUIAN místo UIR.
 */
class Dalten_Export_SrealityTest extends Dalten_Export_Sreality
{
	/**
	 * {@inheritdoc}
	 *
	 * Testovací verze - odesílá RUIAN místo UIR.
	 */
	protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		$convertedValues = parent::_convert($convertedValues, $originalvalues, $entityName);

		if (($entityName === 'listing') or ($entityName == 'project')) {
			$convertedValues['locality_ruian_level'] = $convertedValues['locality_uir_level'];
			$convertedValues['locality_ruian'] = $convertedValues['locality_uir'];
			unset($convertedValues['locality_uir_level'], $convertedValues['locality_uir']);
		}

		if ($entityName == 'project') {
			$convertedValues['description'] = $originalvalues['projekt_zakladni_popis'] . ' ' . $originalvalues['projekt_popis'];
			$convertedValues['annotation'] = mb_substr($convertedValues['description'], 0, 247, 'UTF-8')  . '...';
		}

		return $convertedValues;
	}
}
