<?php
/**
 * Vylepšovač adres.
 *
 * Na Annonci se adresy posílají v textové podobě. Tato třída je upravuje adresu jdoucí z Irestu,
 * aby došlo k lepšímu zařazení na Annonci.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_Annonce_Static implements Dalten_AddressConverter_Annonce_Interface
{
	/**
	 * UIR okres_kod pro Prahu.
	 */
	const OKRES_KOD_PRAHA = 3100;

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		$inCzechRepublic = ($input['nemovitost_uir_stat'] == 'CZ');
		$input['country'] = $input['nemovitost_uir_stat'];
		$input['city'] = $input['nemovitost_uir_obec_text'];
		$input['district'] = $input['nemovitost_uir_okres_text'];
		$input['street'] = '';

		if ($input['nemovitost_uir_ulice_text']) {
			$input['street'] = $input['nemovitost_uir_ulice_text'];
		}

		if ($inCzechRepublic && ($input['nemovitost_uir_okres_kod']==self::OKRES_KOD_PRAHA)) {
			$input['district'] = 'Praha hl.m.'; // v naší databázi je jinak, to se jim nelíbí
			$input['city'] = $input['nemovitost_uir_pobvod_text']; // jako město se posílá pražský obvod
		}

		return $input;
	}

}