<?php
/**
 * Statický převodník pro České reality. Číselníky má zadrátované v sobě.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_Ceskereality_Static
	implements Dalten_AddressConverter_Ceskereality_Interface
{
	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Původní informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		$prevodnikStatu = self::_getStatCiselnik();
		$prevodnikOkresu = self::_getOkresCiselnik();
		$prevodnikSpravnihoObPha = self::_getSpravnihoObCiselnik();

		$input['zeme'] = $prevodnikStatu[ $input['nemovitost_uir_stat'] ];
		if ($input['nemovitost_uir_stat'] == 'CZ') {
			$input['okres'] = $prevodnikOkresu[ $input['nemovitost_uir_okres_kod'] ];
			// u nemovitostí z Prahy přidáváme kód správního obvodu
			if (
				$input['nemovitost_uir_mcast_kod'] &&
				isset($prevodnikSpravnihoObPha[ $input['nemovitost_uir_mcast_kod'] ])
			) {
				$kodSpravnihoobPha = $prevodnikSpravnihoObPha[ $input['nemovitost_uir_mcast_kod'] ];
				$input['kod_spravnihoob_pha'] = $kodSpravnihoobPha + 1100;
			}
		} else {
			// u nemovitostí ležících mimo ČR povinnou položku okres a obec_kod vyplňte kódem 0
			$input['okres'] = 0;
			$input['obec_kod'] = 0;
		}
		return $input;
	}

	/**
	 * Vrací číselník na převod států z dvoupísmeného kódu do kódu Českých realit.
	 *
	 * @static
	 * @return array
	 */
	private static function _getStatCiselnik()
	{
		$stat['AF'] = '004';
		$stat['AL'] = '008';
		$stat['AQ'] = '010';
		$stat['DZ'] = '012';
		$stat['AS'] = '016';
		$stat['AD'] = '020';
		$stat['AO'] = '024';
		$stat['AG'] = '028';
		$stat['AZ'] = '031';
		$stat['AR'] = '032';
		$stat['AU'] = '036';
		$stat['AT'] = '040';
		$stat['BS'] = '044';
		$stat['BH'] = '048';
		$stat['BD'] = '050';
		$stat['AM'] = '051';
		$stat['BB'] = '052';
		$stat['BE'] = '056';
		$stat['BM'] = '060';
		$stat['BT'] = '064';
		$stat['BO'] = '068';
		$stat['BA'] = '070';
		$stat['BW'] = '072';
		$stat['BV'] = '074';
		$stat['BR'] = '076';
		$stat['BZ'] = '084';
		$stat['IO'] = '086';
		$stat['SB'] = '090';
		$stat['VG'] = '092';
		$stat['BN'] = '096';
		$stat['BG'] = '100';
		$stat['MM'] = '104';
		$stat['BI'] = '108';
		$stat['BY'] = '112';
		$stat['KH'] = '116';
		$stat['CM'] = '120';
		$stat['CA'] = '124';
		$stat['CV'] = '132';
		$stat['KY'] = '136';
		$stat['CF'] = '140';
		$stat['LK'] = '144';
		$stat['TD'] = '148';
		$stat['CL'] = '152';
		$stat['CN'] = '156';
		$stat['TW'] = '158';
		$stat['CX'] = '162';
		$stat['CC'] = '166';
		$stat['CO'] = '170';
		$stat['KM'] = '174';
		$stat['YT'] = '175';
		$stat['CG'] = '178';
		$stat['CD'] = '180';
		$stat['CK'] = '184';
		$stat['CR'] = '188';
		$stat['HR'] = '191';
		$stat['CU'] = '192';
		$stat['CY'] = '196';
		$stat['CZ'] = '203';
		$stat['BJ'] = '204';
		$stat['DK'] = '208';
		$stat['DM'] = '212';
		$stat['DO'] = '214';
		$stat['EC'] = '218';
		$stat['SV'] = '222';
		$stat['GQ'] = '226';
		$stat['ET'] = '231';
		$stat['ER'] = '232';
		$stat['EE'] = '233';
		$stat['FO'] = '234';
		$stat['FK'] = '238';
		$stat['GS'] = '239';
		$stat['FJ'] = '242';
		$stat['FI'] = '246';
		$stat['AX'] = '248';
		$stat['FR'] = '250';
		$stat['GF'] = '254';
		$stat['PF'] = '258';
		$stat['TF'] = '260';
		$stat['DJ'] = '262';
		$stat['GA'] = '266';
		$stat['GE'] = '268';
		$stat['GM'] = '270';
		$stat['PS'] = '275';
		$stat['DE'] = '276';
		$stat['GH'] = '288';
		$stat['GI'] = '292';
		$stat['KI'] = '296';
		$stat['GR'] = '300';
		$stat['GL'] = '304';
		$stat['GD'] = '308';
		$stat['GP'] = '312';
		$stat['GU'] = '316';
		$stat['GT'] = '320';
		$stat['GN'] = '324';
		$stat['GY'] = '328';
		$stat['HT'] = '332';
		$stat['HM'] = '334';
		$stat['VA'] = '336';
		$stat['HN'] = '340';
		$stat['HK'] = '344';
		$stat['HU'] = '348';
		$stat['IS'] = '352';
		$stat['IN'] = '356';
		$stat['ID'] = '360';
		$stat['IR'] = '364';
		$stat['IQ'] = '368';
		$stat['IE'] = '372';
		$stat['IL'] = '376';
		$stat['IT'] = '380';
		$stat['CI'] = '384';
		$stat['JM'] = '388';
		$stat['JP'] = '392';
		$stat['KZ'] = '398';
		$stat['JO'] = '400';
		$stat['KE'] = '404';
		$stat['KP'] = '408';
		$stat['KR'] = '410';
		$stat['KW'] = '414';
		$stat['KG'] = '417';
		$stat['LA'] = '418';
		$stat['LB'] = '422';
		$stat['LS'] = '426';
		$stat['LV'] = '428';
		$stat['LR'] = '430';
		$stat['LY'] = '434';
		$stat['LI'] = '438';
		$stat['LT'] = '440';
		$stat['LU'] = '442';
		$stat['MO'] = '446';
		$stat['MG'] = '450';
		$stat['MW'] = '454';
		$stat['MY'] = '458';
		$stat['MV'] = '462';
		$stat['ML'] = '466';
		$stat['MT'] = '470';
		$stat['MQ'] = '474';
		$stat['MR'] = '478';
		$stat['MU'] = '480';
		$stat['MX'] = '484';
		$stat['MC'] = '492';
		$stat['MN'] = '496';
		$stat['MD'] = '498';
		$stat['ME'] = '499';
		$stat['MS'] = '500';
		$stat['MA'] = '504';
		$stat['MZ'] = '508';
		$stat['OM'] = '512';
		$stat['NA'] = '516';
		$stat['NR'] = '520';
		$stat['NP'] = '524';
		$stat['NL'] = '528';
		$stat['AN'] = '530';
		$stat['AW'] = '533';
		$stat['NC'] = '540';
		$stat['VU'] = '548';
		$stat['NZ'] = '554';
		$stat['NI'] = '558';
		$stat['NE'] = '562';
		$stat['NG'] = '566';
		$stat['NU'] = '570';
		$stat['NF'] = '574';
		$stat['NO'] = '578';
		$stat['MP'] = '580';
		$stat['UM'] = '581';
		$stat['FM'] = '583';
		$stat['MH'] = '584';
		$stat['PW'] = '585';
		$stat['PK'] = '586';
		$stat['PA'] = '591';
		$stat['PG'] = '598';
		$stat['PY'] = '600';
		$stat['PE'] = '604';
		$stat['PH'] = '608';
		$stat['PN'] = '612';
		$stat['PL'] = '616';
		$stat['PT'] = '620';
		$stat['GW'] = '624';
		$stat['TL'] = '626';
		$stat['PR'] = '630';
		$stat['QA'] = '634';
		$stat['RE'] = '638';
		$stat['RO'] = '642';
		$stat['RU'] = '643';
		$stat['RW'] = '646';
		$stat['SH'] = '654';
		$stat['KN'] = '659';
		$stat['AI'] = '660';
		$stat['LC'] = '662';
		$stat['PM'] = '666';
		$stat['VC'] = '670';
		$stat['SM'] = '674';
		$stat['ST'] = '678';
		$stat['SA'] = '682';
		$stat['SN'] = '686';
		$stat['RS'] = '688';
		$stat['SC'] = '690';
		$stat['SL'] = '694';
		$stat['SG'] = '702';
		$stat['SK'] = '703';
		$stat['VN'] = '704';
		$stat['SI'] = '705';
		$stat['SO'] = '706';
		$stat['ZA'] = '710';
		$stat['ZW'] = '716';
		$stat['ES'] = '724';
		$stat['EH'] = '732';
		$stat['SD'] = '736';
		$stat['SR'] = '740';
		$stat['SJ'] = '744';
		$stat['SZ'] = '748';
		$stat['SE'] = '752';
		$stat['CH'] = '756';
		$stat['SY'] = '760';
		$stat['TJ'] = '762';
		$stat['TH'] = '764';
		$stat['TG'] = '768';
		$stat['TK'] = '772';
		$stat['TO'] = '776';
		$stat['TT'] = '780';
		$stat['AE'] = '784';
		$stat['TN'] = '788';
		$stat['TR'] = '792';
		$stat['TM'] = '795';
		$stat['TC'] = '796';
		$stat['TV'] = '798';
		$stat['UG'] = '800';
		$stat['UA'] = '804';
		$stat['MK'] = '807';
		$stat['EG'] = '818';
		$stat['GB'] = '826';
		$stat['GG'] = '831';
		$stat['JE'] = '832';
		$stat['IM'] = '833';
		$stat['TZ'] = '834';
		$stat['US'] = '840';
		$stat['VI'] = '850';
		$stat['BF'] = '854';
		$stat['UY'] = '858';
		$stat['UZ'] = '860';
		$stat['VE'] = '862';
		$stat['WF'] = '876';
		$stat['WS'] = '882';
		$stat['YE'] = '887';
		$stat['ZM'] = '894';
		return $stat;
	}

	/**
	 * Vrátí číselník okresů z UIR do formátu Českých realit.
	 *
	 * @static
	 * @return array Vrácený číselník.
	 */
	private static function _getOkresCiselnik()
	{
		$okres[3100]			= 76;	// Hlavní město
		$okres[3201]			= 1;	// Benešov
		$okres[3202]			= 2;	// Beroun
		$okres[3203]			= 3;	// Kladno
		$okres[3204]			= 4;	// Kolín
		$okres[3205]			= 5;	// Kutná Hora
		$okres[3206]			= 6;	// Mělník
		$okres[3207]			= 7;	// Mladá Boleslav
		$okres[3208]			= 8;	// Nymburk
		$okres[3209]			= 9;	// Praha-východ
		$okres[3210]			= 10;	// Praha-západ
		$okres[3211]			= 11;	// Příbram
		$okres[3212]			= 12;	// Rakovník
		$okres[3301]			= 13;	// České Budějovice
		$okres[3302]			= 14;	// Český Krumlov
		$okres[3303]			= 15;	// Jindřichův Hradec
		$okres[3304]			= 16;	// Pelhřimov
		$okres[3305]			= 17;	// Písek
		$okres[3306]			= 18;	// Prachatice
		$okres[3307]			= 19;	// Strakonice
		$okres[3308]			= 20;	// Tábor
		$okres[3401]			= 21;	// Domažlice
		$okres[3402]			= 22;	// Cheb
		$okres[3403]			= 23;	// Karlovy Vary
		$okres[3404]			= 24;	// Klatovy
		$okres[3405]			= 25;	// Plzeň-město
		$okres[3406]			= 26;	// Plzeň-jih
		$okres[3407]			= 27;	// Plzeň-sever
		$okres[3408]			= 28;	// Rokycany
		$okres[3409]			= 29;	// Sokolov
		$okres[3410]			= 30;	// Tachov
		$okres[3501]			= 31;	// Česká Lípa
		$okres[3502]			= 32;	// Děčín
		$okres[3503]			= 33;	// Chomutov
		$okres[3504]			= 34;	// Jablonec nad Nisou
		$okres[3505]			= 35;	// Liberec
		$okres[3506]			= 36;	// Litoměřice
		$okres[3507]			= 37;	// Louny
		$okres[3508]			= 38;	// Most
		$okres[3509]			= 39;	// Teplice
		$okres[3510]			= 40;	// Ústí nad Labem
		$okres[3601]			= 41;	// Havlíčkův Brod
		$okres[3602]			= 42;	// Hradec Králové
		$okres[3603]			= 43;	// Chrudim
		$okres[3604]			= 44;	// Jičín
		$okres[3605]			= 45;	// Náchod
		$okres[3606]			= 46;	// Pardubice
		$okres[3607]			= 47;	// Rychnov nad Kněžnou
		$okres[3608]			= 48;	// Semily
		$okres[3609]			= 49;	// Svitavy
		$okres[3610]			= 50;	// Trutnov
		$okres[3611]			= 51;	// Ústí nad Orlicí
		$okres[3701]			= 52;	// Blansko
		$okres[3702]			= 53;	// Brno-město
		$okres[3703]			= 54;	// Brno-venkov
		$okres[3704]			= 55;	// Břeclav
		$okres[3705]			= 63;	// Zlín
		$okres[3706]			= 56;	// Hodonín
		$okres[3707]			= 57;	// Jihlava
		$okres[3708]			= 58;	// Kroměříž
		$okres[3709]			= 59;	// Prostějov
		$okres[3710]			= 60;	// Třebíč
		$okres[3711]			= 61;	// Uherské Hradiště
		$okres[3712]			= 62;	// Vyškov
		$okres[3713]			= 64;	// Znojmo
		$okres[3714]			= 65;	// Žďár nad Sázavou
		$okres[3801]			= 66;	// Bruntál
		$okres[3802]			= 67;	// Frýdek-Místek
		$okres[3803]			= 68;	// Karviná
		$okres[3804]			= 69;	// Nový Jičín
		$okres[3805]			= 70;	// Olomouc
		$okres[3806]			= 71;	// Opava
		$okres[3807]			= 72;	// Ostrava-město
		$okres[3808]			= 73;	// Přerov
		$okres[3809]			= 74;	// Šumperk
		$okres[3810]			= 75;	// Vsetín
		$okres[3811]			= 139;	// Jeseník
		$okres[500054]		= 77;	// Praha 1
		$okres[500089]		= 78;	// Praha 2
		$okres[500097]		= 79;	// Praha 3
		$okres[500119]		= 80;	// Praha 4
		$okres[500143]		= 81;	// Praha 5
		$okres[500178]		= 82;	// Praha 6
		$okres[500186]		= 83;	// Praha 7
		$okres[500208]		= 84;	// Praha 8
		$okres[500216]		= 85;	// Praha 9
		$okres[500224]		= 86;	// Praha 10
		$okres[547034]		= 87;	// Praha 11
		$okres[547107]		= 88;	// Praha 12
		$okres[539694]		= 89;	// Praha 13
		$okres[547361]		= 90;	// Praha 14
		$okres[547387]		= 91;	// Praha 15
		return $okres;
	}

	/**
	 * Vrátí číselník správních obvodů (ty jsou jen v Praze).
	 *
	 * @static
	 * @return array Číselník správních obvodů.
	 */
	private static function _getSpravnihoObCiselnik()
	{
		return array(
			538060 => 9,
			538078 => 2,
			538124 => 8,
			538175 => 4,
			538205 => 5,
			538302 => 1,
			538353 => 1,
			538361 => 2,
			538388 => 2,
			538400 => 1,
			538531 => 2,
			538736 => 9,
			539007 => 9,
			539449 => 6,
			539465 => 6,
			539589 => 6,
			539635 => 3,
			539678 => 5,
			539724 => 1,
			539791 => 1,
			539864 => 6,
			539899 => 7,
			547042 => 4,
			547051 => 2,
			547115 => 6,
			547140 => 6,
			547158 => 6,
			547271 => 6,
			547298 => 8,
			547301 => 8,
			547310 => 9,
			547328 => 7,
			547379 => 5,
			547395 => 5,
			547409 => 5,
			500054 => 1,
			500224 => 0,
			547034 => 1,
			547107 => 2,
			539694 => 3,
			547361 => 4,
			547387 => 5,
			539601 => 6,
			547174 => 7,
			547417 => 8,
			547344 => 9,
			500089 => 2,
			538213 => 0,
			538949 => 1,
			538931 => 2,
			500097 => 3,
			500119 => 4,
			500143 => 5,
			500178 => 6,
			500186 => 7,
			500208 => 8,
			500216 => 9
		);
	}
}