<?php
/**
 * Převodník z adresního sytému Irestů (UIR) do adresního systému používaného serverem Nehnutelnosti.sk.
 *
 * Protože se krmí soubory je univerzální skrz všecky Iresty.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_RealsoftSk_Universal implements Dalten_AddressConverter_RealsoftSk_Interface
{
	protected $_map = array();

	/**
	 * Kontruktor. Nahrává převodní mapu z INI souboru.
	 *
	 * @param string $mapFile Cesta k INI souboru s převodníkem.
	 */
	function __construct($mapFile)
	{
		$this->_map = parse_ini_file($mapFile, true);
	}

	/**
	 * Převede adresu u nemovitosti do jiného adresního systému.
	 *
	 * @param array $input Informace o nemovitosti.
	 *
	 * @return array Informace o nemovitosti s upravenou adresou.
	 */
	function convertAddress(array $input)
	{
		if ($input['nemovitost_uir_stat']=='SK') {
			$input['nemovitost_uir_stat'] = 1;
		}

		$uliceKod = $input['nemovitost_uir_ulice_kod'];


		$input['street_show'] = 1;
		$input['street_id'] = 0;
		$input['citypart_id'] = 0;

		// pokud je ulice vyplněná, pokusíme se zjistit její kód
		// pokud se to nepodaří, dáme do textu ulice část obce a nastavíme nezobrazovat ulici
		if (isset($this->_map['ulice'][$uliceKod])) {
			$input['street_id'] = $this->_map['ulice'][$uliceKod];
		} else {
			if (!empty($input['nemovitost_uir_obec_text'])) {
				$input['nemovitost_uir_ulice_text'] = $input['nemovitost_uir_obec_text'];
			}
			if (!empty($input['nemovitost_uir_cobce_text'])) {
				$input['nemovitost_uir_ulice_text'] = $input['nemovitost_uir_cobce_text'];
			}
			$input['street_show'] = 0;
		}

		return $input;
	}
}