<?php
/**
 * Loguje do konzole volání XML-RPC exportu. Parametry funkcí a hodnoty odpovědí jsou zakódovány pomocí JSONu,
 * celý výstup je strojově čitelný.
 *
 * Ukázka formátu logu (přihlášení do RAMSu):
 *
 * <pre>
 * getHash -&gt; [{"name":"jmeno"}]
 * getHash &lt;- {"status":200,"statusMessage":"OK","output":{"session_id":"a0738c4e2fd2fcd3db2505a73f56c011","hash":"2b89b8bd32ad9346176782ecef827434"}}
 * login -&gt; [{"session_id":"a0738c4e2fd2fcd3db2505a73f56c011","password":"6ca85d96fd25dd04fc37553de92b970d"}]
 * login &lt;- {"status":200,"statusMessage":"OK"}
 * </pre>
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Backend
 */
class Dalten_Export_Api_Backend_Logger_JsonEcho implements Dalten_Export_Api_Backend_Logger_LoggerInterface
{
	protected $_encoding;

	/**
	 * Kostruktor.
	 *
	 * @param string $encoding Kódování pro funkci xmlrpc_decode.
	 */
	function __construct($encoding = 'utf8')
	{
		$this->_encoding = $encoding;
	}

	/**
	 * {@inheritdoc}
	 */
	public function logRemoteCall($methodName, $data)
	{
		$data = xmlrpc_decode($data, $this->_encoding);
		echo $methodName . ' -> ' . json_encode($data) . PHP_EOL;
	}

	/**
	 * {@inheritdoc }
	 */
	public function logRemoteResponse($methodName, $reponseData)
	{
		$data = xmlrpc_decode($reponseData, $this->_encoding);
		echo $methodName . ' <- ' . json_encode($data) . PHP_EOL;
	}
}