<?php

/**
 * Určuje metody, které je třeba implementovat pro logger požadavků a odpovědí na vzdálený server.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Backend
 */
interface Dalten_Export_Api_Backend_Logger_LoggerInterface
{
	/**
	 * Zaloguje volání vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName Název volané metody.
	 * @param mixed  $data       Data se kterými je metoda volána.
	 */
	public function logRemoteCall($methodName, $data);

	/**
	 * Zaloguje odpověď vzdáleného serveru.
	 *
	 * Způsob logování a zda se vůbec daná událost má logovat je záležitostí konkrétní implementace.
	 *
	 * @param string $methodName  Název volané metody.
	 * @param mixed  $reponseData Odpověď serveru.
	 */
	public function logRemoteResponse($methodName, $reponseData);
}
