<?php
/**
 * Pomocná třída na sestavování XML podle definice v INI souboru.
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Helper
 */
class Dalten_Export_Helper_NestedNewspeak
{
	/**
	 * Umožňuje definovat strukturu výsledného XML přímo v INI souboru exportu.
	 *
	 * Příklad vloží do tagu A tag B (a všechny další tagy definované v sekci a_vnitrek):
	 * <pre>
	 * a.column = 'A'
	 * a.type = 'subNode'
	 * a.subNodeDef = 'a_vnitrek'
	 * [a_vnitrek]
	 * b.column='B'
	 * ...
	 * </pre>
	 *
	 * Funkce rekurzivně volá sama sebe a postupně staví výsledné XML.
	 *
	 * @param Dalten_Xml_SimpleXml         $xml         Kořenový tag.
	 * @param Serenity_Config_Config       $config      Objekt nastavení exportu.
	 * @param Dalten_Export_AbstractExport $exportClass Exportní třída na převádění hodnot.
	 * @param string                       $sectionName Název sekce ini souboru, dle které chceme pracovat.
	 * @param array                        $values      Pole polí dat ve tvaru
	 *             array('nabidka'=>array('id'=>'1',...), 'makler'=>array('jmeno_cele'=>'Pepa Novák',....))
	 * @param string                       $entityType  Typ entity, určuje které pole dat se
	 *                                                  z výše uvedeného použije.
	 */
	public function preparePart(
		Dalten_Xml_SimpleXml         $xml,
		Serenity_Config_Config       $config,
		Dalten_Export_AbstractExport $exportClass,
		                             $sectionName,
		array                        $values,
		                             $entityType
	)
	{
		/* TODO Dopsat zde vyhazování vyjímek při chybějících údajích. */
		$partConfig = $config->__get($sectionName);
		$convertedPart = $exportClass->convertEntityValues($sectionName, $values[$entityType], $partConfig);
		foreach ($partConfig as $itemDef) {
			if (isset($itemDef->type) && $itemDef->type=='subNode') {
				$newNode = $xml->addChild($itemDef->column);
				if (isset($itemDef->entityType)) {
					$newEntityType = $itemDef->entityType;
				} else {
					$newEntityType = 'nabidka';
				}
				$this->preparePart($newNode, $config, $exportClass, $itemDef->subNodeDef, $values, $newEntityType);
			} elseif (isset($itemDef->type) && isset($itemDef->column)) {
				if (isset($convertedPart[$itemDef->column])) {
					$xml->addChild($itemDef->column, /*(string)*/ $convertedPart[$itemDef->column]);
				}
			}
		}
	}
}
