<?php

/**
 * Export do formátu RealityMorava.
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_RealityMorava extends Dalten_Export_AbstractExport
{
	const ZEMEDELSKE_OBJEKTY = 1;
	const KOMERCNI_OBJEKTY = 2;
	const POZEMKY = 3;
	const BYTY = 4;
	const HISTORICKE_OBJEKTY = 5;
	const DOMY_A_VILY = 6;
	const HOTELY = 7;
	const NAJEMNI_DOMY = 8;
	const KOMERCNI_PROSTORY = 9;
	const CHATY = 10;
	const MALE_OBJEKTY = 11;

	const CIL_RODINNY_DUM = 15;
	const CIL_RODINNA_REKREACE = 16;
	const CIL_NAJEMNI_DOMY = 17;
	const CIL_PROSTORY_VYROBA = 21;
	const CIL_PROSTORY_OBCHOD = 22;
	const CIL_OBJEKTY_PRO_OBCHOD = 24;
	const CIL_POZEMKY_ZEMEDELSKE = 31;
	const CIL_POZEMKY_ZAHRADY = 32;
	const CIL_POZEMKY_RYBNIKY = 35;
	const CIL_POZEMKY_STAVEBNI_BYDLENI = 33;
	const CIL_POZEMKY_STAVEBNI_KOMERCNI = 34;
	const CIL_OSTATNI  = 43;

	const ZAKAZKA_TYP_PRODEJ = 1;
	const ZAKAZKA_TYP_PRONAJEM = 2;

	/**
	 * Pomocné magické číslo - značí že se platí pronájem za den.
	 *
	 * To je speciální případ který se musí ošetřit.
	 */
	const MAGIC_ZA_DEN = 1024;

	/**
	 * Převede ty položky na které nestačí Adamův konfig.
	 *
	 * @param array  $convertedValues Převednené položky.
	 * @param array  $originalvalues  Originální položky.
	 * @param string $entityName      Jméno entity.
	 *
	 * @return array Definitivně převedené položky.
	 */
	protected function _convert(array $convertedValues, array $originalvalues, $entityName)
	{
		if ($entityName == 'listing') {
			$convertedValues['druh'] = $this->_convertCategory($originalvalues);
			$convertedValues['mena'] = $this->_convertCurrency($originalvalues);
			if ($convertedValues['mena'] > self::MAGIC_ZA_DEN) {
				// cenu za den nemají v číselníku, dáme ji tedy textově
				$convertedValues['mena'] = $convertedValues['mena'] - self::MAGIC_ZA_DEN; //vracime původní menu
				$convertedValues['cenatext'] .= ' /cena za den'; // a dodáváme text
			}

            $youtubeVirtualTourId = Dalten_Export_Helper_YoutubeIdExtractor::extractYoutubeId($originalvalues['nemovitost_virtualni_prohlidka']);
            if ($youtubeVirtualTourId) {
				$convertedValues['prohlidka_3d_link'] = 'https://www.youtube.com/embed/' . $youtubeVirtualTourId;
			}

            $youtubeVideoTourId = Dalten_Export_Helper_YoutubeIdExtractor::extractYoutubeId($originalvalues['nemovitost_video_prohlidka']);
            if ($youtubeVideoTourId) {
                $convertedValues['prohlidka_3d_link'] = 'https://www.youtube.com/embed/' . $youtubeVideoTourId;
            }

		}
		return $convertedValues;
	}

	/**
	 * Převede typ a opdpovídající podtyp na druh nemovitosti.
	 *
	 * @param array $originalValues Pole s originálními inormacemi o nemovitosti.
	 *
	 * @return int Druh tak jak ho specifikují RealityMorava.
	 */
	private function _convertCategory($originalValues)
	{
		if ($originalValues['nemovitost_typ'] == self::BYTY) {
			if($originalValues['nemovitost_dispozice'] == '1')  return '111';
			if($originalValues['nemovitost_dispozice'] == '2')  return '112';
			if($originalValues['nemovitost_dispozice'] == '3')  return '122';
			if($originalValues['nemovitost_dispozice'] == '4')  return '125';
			if($originalValues['nemovitost_dispozice'] == '5')  return '132';
			if($originalValues['nemovitost_dispozice'] == '6')  return '135';
			if($originalValues['nemovitost_dispozice'] == '7')  return '136';
			if($originalValues['nemovitost_dispozice'] == '8')  return '136';
			if($originalValues['nemovitost_dispozice'] == '9')  return '113';
			if($originalValues['nemovitost_dispozice'] == '10') return '123';
			if($originalValues['nemovitost_dispozice'] == '11') return '126';
			if($originalValues['nemovitost_dispozice'] == '12') return '133';
			if($originalValues['nemovitost_dispozice'] == '13') return '136';
			if($originalValues['nemovitost_dispozice'] == '14') return '136';
			if($originalValues['nemovitost_dispozice'] == '15') return '136';
			if($originalValues['nemovitost_dispozice'] == '16') return '12';
			if($originalValues['nemovitost_dispozice'] == '17') return '12';
			if($originalValues['nemovitost_dispozice'] == '18') return '11'; // pokoj -> byt malý
		}
		if ($originalValues['nemovitost_typ'] == self::DOMY_A_VILY) {
			return self::CIL_RODINNY_DUM;
		}
		/*
		 * Patrně se nepoužívá.
		 * if($originalValues['nemovitost_druh_stavby'] == self::POZEMKY) return '15';
		 */
		if ($originalValues['nemovitost_typ'] == self::CHATY) return self::CIL_RODINNA_REKREACE;
		if ($originalValues['nemovitost_typ'] == self::NAJEMNI_DOMY) return self::CIL_NAJEMNI_DOMY;

		if ($originalValues['nemovitost_typ'] == self::KOMERCNI_PROSTORY) {
			if($originalValues['nemovitost_druh_prostor'] == '1') return self::CIL_PROSTORY_VYROBA;
			if($originalValues['nemovitost_druh_prostor'] == '2') return self::CIL_PROSTORY_VYROBA;
			if($originalValues['nemovitost_druh_prostor'] == '3') return self::CIL_PROSTORY_VYROBA;
			if($originalValues['nemovitost_druh_prostor'] == '5') return self::CIL_PROSTORY_OBCHOD;
			if($originalValues['nemovitost_druh_prostor'] == '6') return self::CIL_PROSTORY_OBCHOD;
			if($originalValues['nemovitost_druh_prostor'] == '7') return self::CIL_PROSTORY_OBCHOD;
		}

		if ($originalValues['nemovitost_typ'] == self::ZEMEDELSKE_OBJEKTY || $originalValues['nemovitost_typ'] == self::KOMERCNI_OBJEKTY) {
			return self::CIL_OBJEKTY_PRO_OBCHOD;
		}

		if ($originalValues['nemovitost_typ'] == self::POZEMKY) {
			if ($originalValues['nemovitost_druh_pozemku'] == '3') return self::CIL_POZEMKY_ZEMEDELSKE;
			if ($originalValues['nemovitost_druh_pozemku'] == '4') return self::CIL_POZEMKY_ZEMEDELSKE;
			if ($originalValues['nemovitost_druh_pozemku'] == '5') return self::CIL_POZEMKY_ZEMEDELSKE;
			if ($originalValues['nemovitost_druh_pozemku'] == '6') return self::CIL_POZEMKY_ZAHRADY;
			if ($originalValues['nemovitost_druh_pozemku'] == '2') return self::CIL_POZEMKY_STAVEBNI_BYDLENI;
			if ($originalValues['nemovitost_druh_pozemku'] == '1') return self::CIL_POZEMKY_STAVEBNI_KOMERCNI;
            if ($originalValues['nemovitost_druh_pozemku'] == '8') return self::CIL_POZEMKY_RYBNIKY;
        }

		return self::CIL_OSTATNI;
	}

	/**
	 * Vrací kód měny. RealityMorava v něm mají i jednotku prodeje/pronájmu (za m2, za měsíc atd)
	 *
	 * @param array $originalValues Pole s informacemi o nemovitosti.
	 *
	 * @return int Převedený kód měny.
	 */
	function _convertCurrency($originalValues)
	{
		$mena = 99; // jiné
		$prevodMeny = array(
			1 => 1,  //CZK
			2 => 31, //USD
			3 => 21  //EUR
		);
		if (isset($prevodMeny[ $originalValues['nemovitost_mena'] ])) {
			$mena = $prevodMeny[ $originalValues['nemovitost_mena'] ];
		}

		$za = 0; // cena celkem
		if ($originalValues['zakazka_typ'] == self::ZAKAZKA_TYP_PRODEJ) {
			if ($originalValues['nemovitost_cena_prodej_jednotka'] == 3) {
				$za = 3; //cena za m2
			}
		} elseif ($originalValues['zakazka_typ'] == self::ZAKAZKA_TYP_PRONAJEM) {
			$prevodZa = array(
				2 => 1, //za měsíc
				4 => 4, //za m2/měsíc
				5 => 5, //za m2/rok
				6 => 2, //za rok
				7 => self::MAGIC_ZA_DEN  //za den - pozor! oni hodnotu za den nemají!
			);
			$za = $prevodZa[ $originalValues['nemovitost_cena_pronajem_jednotka'] ];
		}

		return $mena + $za;
	}
}
