<?php
/**
 * Export na DomyBytyPozemky.cz
 *
 * Jedná se jen o upravený export na Sreality.
 *
 * Jejich advert_rkid může být jen číslo, posíláme tedy IDčko nabídky, ne kód.
 */
class Dalten_Export_Api_DomyBytyPozemky extends Dalten_Export_Api_Sreality
{
	/**
	 * Odstraní nabídku ze vzdáleného serveru.
	 *
	 * @param array $listingData      Data nabídky ve formátu iRest 1.
	 * @param array $additionalParams Specifická data pro daný export (zde prázdné pole).
	 *
	 * @return Dalten_Export_Api_ServerResponse Odpověď serveru.
	 */
	public function deleteListing(array $listingData, array $additionalParams = array())
	{
		$response = $this->_backend->delAdvert(
			$this->_getSessionId(),
			null,
			isset($listingData['id']) ? $listingData['id'] : null
		);

		return new Dalten_Export_Api_ServerResponse(
			$response->status == 200,
			$response->status,
			$response->statusMessage
		);
	}
}