<?php

class Dalten_Export_Api_Backend_XmlTest extends \PHPUnit\Framework\TestCase
{

	public function testBuildBooleanValue()
	{
		$data = array('node' => true, 'node2' => false);
		$xml = new Dalten_Export_Api_Backend_Idnes_Xml($data);


		$expected = new DOMDocument('1.0', 'utf-8');
		$expected->loadXML('<nabidka><node>1</node><node2>0</node2></nabidka>');

		$actual = new DOMDocument();
		$actual->loadXML($xml->build());
		$this->assertEqualXMLStructure($expected->firstChild, $actual->firstChild);

	}
	public function testBuildEmptyValue()
	{
		$data = array();
		$xml = new Dalten_Export_Api_Backend_Idnes_Xml($data);


		$expected = new DOMDocument('1.0', 'utf-8');
		$expected->loadXML('<nabidka></nabidka>');

		$actual = new DOMDocument();
		$actual->loadXML($xml->build());
		$this->assertEqualXMLStructure($expected->firstChild, $actual->firstChild);

	}

	public function testBuildSimpleValue()
	{
		$data = array('node' => 'value');
		$xml = new Dalten_Export_Api_Backend_Idnes_Xml($data);


		$expected = new DOMDocument('1.0', 'utf-8');
		$expected->loadXML('<nabidka><node>value</node></nabidka>');

		$actual = new DOMDocument();
		$actual->loadXML($xml->build());
		$this->assertEqualXMLStructure($expected->firstChild, $actual->firstChild);

	}

	public function testBuildArrayValue()
	{
		$data = array();
		$data['multi_value'][] = 'John';
		$data['multi_value'][] = 'Doe';

		$expected = new DomDocument('1.0', 'utf-8');
		$expected->loadXML('<nabidka><multi_value>John</multi_value><multi_value>Doe</multi_value></nabidka>');

		$xml = new Dalten_Export_Api_Backend_Idnes_Xml($data);
		$actual = new DOMDocument();
		$actual->loadXML($xml->build());

		$this->assertEqualXMLStructure($expected->firstChild, $actual->firstChild);
	}

	public function testAddMediaFiles()
	{
		$data = array();
		$data['foto'][] = array(
			'ord' => 1,
			'hash' => 'strasneTajnyHash',
			'filename' => '/jemno/souboru.jpg'
		);
		$data['foto'][] = array(
			'ord' => 2,
			'hash' => 'strasneTajnyHash2',
			'filename' => '/jemno/souboru2.jpg'
		);
		$data['video'][] = array(
			'ord' => 1,
			'hash' => 'strasneTajnyHash',
			'filename' => '/jemno/souboru.mpg'
		);


		$expected = new DomDocument('1.0', 'utf-8');
		$expected->loadXML('<nabidka>
		<foto><ord>1</ord><hash>strasneTajnyHash</hash><filename>/jemno/souboru.jpg</filename></foto>
		<foto><ord>2</ord><hash>strasneTajnyHash2</hash><filename>/jemno/souboru2.jpg</filename></foto>
		<video><ord>1</ord><hash>strasneTajnyHash2</hash><filename>/jemno/souboru.mpg</filename></video>
		</nabidka>');

		$xml = new Dalten_Export_Api_Backend_Idnes_Xml($data);
		$actual = new DOMDocument();
		$actual->loadXML($xml->build());

		$this->assertEqualXMLStructure($expected->firstChild, $actual->firstChild);
	}

}