<?php
$idnesLines = file('idnes-staty.csv');
$irestLines = file('staty-irest.txt');

$code2name = [];

foreach ($irestLines as $line) {
    list($code, $name) = explode(': ', trim($line));
    $name = trim($name, "'");
    $code2name[$code] = $name;
}

$name2id = [];
foreach ($idnesLines as $line) {
    list($id, $nope, $name) = explode(',', trim($line));
    $name2id[$name] = $id;
}

$convert = [];
foreach ($code2name as $code=>$name) {
    if (isset($name2id[$name])) {
        $convert[$code] = intval($name2id[$name]);
    } else {
        // neumíme
        echo sprintf('// %s = %s ?', $code, $name) . PHP_EOL;
    }
}
var_export($convert);

