<?php
/**
 * Šablona XML attributu pro exporty.
 *
 * @category Dalten
 * @package  Xml
 */
class Dalten_Xml_Template_Attribute extends Dalten_Xml_Template_Node
{
	protected $_staticValue = null;

	/**
	 * {@inheritdoc}
	 */
	public function fill(SimpleXMLElement $rootElement, array $data)
	{
		if ($this->_staticValue) {
			$rootElement->addAttribute($this->_name, $this->_guardFloatIfNeeded($this->_staticValue) );
			return $this->_staticValue;
		}

		if (isset($data[$this->_variableName])) {
			$value = $data[$this->_variableName];
			$rootElement->addAttribute($this->_name, $this->_guardFloatIfNeeded($value) );
			return $value;
		}

		return null;
	}

	/**
	 * Nastaví atributu statickou hodnotu která se vyplní VŽDY.
	 *
	 * @param string $value Hodnota atributu.
	 *
	 * @return Dalten_Xml_Template_Attribute Fluent interface.
	 */
	public function staticValue($value)
	{
		$this->_staticValue = $value;
		return $this;
	}
}
