<?php
/**
 * Nový převodník na České reality, který používá RUIAN data.
 *
 * @category Dalten
 * @package  AdressConverter
 */
class Dalten_AddressConverter_Ceskereality_Ruian
    implements Dalten_AddressConverter_Ceskereality_Interface
{
    function convertAddress(array $input)
    {
        $prevodnikStatu = self::_getStatCiselnik();
        $input['zeme'] = $prevodnikStatu[ $input['nemovitost_uir_stat'] ];
        if ($input['nemovitost_uir_stat'] == 'CZ') {

            if (!empty($input['ruian_adresa_kod'])) {
                $input['ruian_uroven'] = 11;
                $input['ruian_kod'] = (int)$input['ruian_adresa_kod'];
            } elseif (!empty($input['nemovitost_uir_ulice_kod'])) {
                $input['ruian_uroven'] = 7;
                $input['ruian_kod'] = (int)$input['nemovitost_uir_ulice_kod'];
            } elseif (!empty($input['nemovitost_uir_mcast_kod'])) {
                $input['ruian_uroven'] = 17;
                $input['ruian_kod'] = (int)$input['nemovitost_uir_mcast_kod'];
            } elseif (!empty($input['nemovitost_uir_cobce_kod'])) {
                $input['ruian_uroven'] = 5;
                $input['ruian_kod'] = (int)$input['nemovitost_uir_cobce_kod'];
            } elseif (!empty($input['nemovitost_uir_obec_kod'])) {
                $input['ruian_uroven'] = 3;
                $input['ruian_kod'] = (int)$input['nemovitost_uir_obec_kod'];
            } elseif (!empty($input['nemovitost_uir_okres_kod'])) {
                $input['ruian_uroven'] = 1;
                $input['ruian_kod'] = (int)$input['nemovitost_uir_okres_kod'];
            }

            if (!isset($input['nabidka_gps_presnost'])) {
                $input['nabidka_gps_presnost'] = 3;
            }

            // znepřesnění - zobrazíme (podle Srealit):
            // 1) plná adresa
            // 2) ulice, část obce
            // 3) mčást, obec (toto volíme i v případě nenastaveného znepřesnění)

            $znepresneni = array(
                0 => 3,
                1 => 0,
                2 => 2,
                3 => 3
            );

            $input['nezverejnovat_polohu'] = $znepresneni[$input['nabidka_gps_presnost']];


        } else {
            // u nemovitostí ležících mimo ČR povinnou položku okres a obec_kod vyplňte kódem 0
            $input['okres'] = 0;
            $input['obec_kod'] = 0;
            $input['nezverejnovat_polohu'] = 3; // nezobrazovat ulici
        }

        return $input;
    }

    /**
     * Vrací číselník na převod států z dvoupísmeného kódu do kódu Českých realit.
     *
     * @static
     * @return array
     */
    private static function _getStatCiselnik()
    {
        $stat['AF'] = '004';
        $stat['AL'] = '008';
        $stat['AQ'] = '010';
        $stat['DZ'] = '012';
        $stat['AS'] = '016';
        $stat['AD'] = '020';
        $stat['AO'] = '024';
        $stat['AG'] = '028';
        $stat['AZ'] = '031';
        $stat['AR'] = '032';
        $stat['AU'] = '036';
        $stat['AT'] = '040';
        $stat['BS'] = '044';
        $stat['BH'] = '048';
        $stat['BD'] = '050';
        $stat['AM'] = '051';
        $stat['BB'] = '052';
        $stat['BE'] = '056';
        $stat['BM'] = '060';
        $stat['BT'] = '064';
        $stat['BO'] = '068';
        $stat['BA'] = '070';
        $stat['BW'] = '072';
        $stat['BV'] = '074';
        $stat['BR'] = '076';
        $stat['BZ'] = '084';
        $stat['IO'] = '086';
        $stat['SB'] = '090';
        $stat['VG'] = '092';
        $stat['BN'] = '096';
        $stat['BG'] = '100';
        $stat['MM'] = '104';
        $stat['BI'] = '108';
        $stat['BY'] = '112';
        $stat['KH'] = '116';
        $stat['CM'] = '120';
        $stat['CA'] = '124';
        $stat['CV'] = '132';
        $stat['KY'] = '136';
        $stat['CF'] = '140';
        $stat['LK'] = '144';
        $stat['TD'] = '148';
        $stat['CL'] = '152';
        $stat['CN'] = '156';
        $stat['TW'] = '158';
        $stat['CX'] = '162';
        $stat['CC'] = '166';
        $stat['CO'] = '170';
        $stat['KM'] = '174';
        $stat['YT'] = '175';
        $stat['CG'] = '178';
        $stat['CD'] = '180';
        $stat['CK'] = '184';
        $stat['CR'] = '188';
        $stat['HR'] = '191';
        $stat['CU'] = '192';
        $stat['CY'] = '196';
        $stat['CZ'] = '203';
        $stat['BJ'] = '204';
        $stat['DK'] = '208';
        $stat['DM'] = '212';
        $stat['DO'] = '214';
        $stat['EC'] = '218';
        $stat['SV'] = '222';
        $stat['GQ'] = '226';
        $stat['ET'] = '231';
        $stat['ER'] = '232';
        $stat['EE'] = '233';
        $stat['FO'] = '234';
        $stat['FK'] = '238';
        $stat['GS'] = '239';
        $stat['FJ'] = '242';
        $stat['FI'] = '246';
        $stat['AX'] = '248';
        $stat['FR'] = '250';
        $stat['GF'] = '254';
        $stat['PF'] = '258';
        $stat['TF'] = '260';
        $stat['DJ'] = '262';
        $stat['GA'] = '266';
        $stat['GE'] = '268';
        $stat['GM'] = '270';
        $stat['PS'] = '275';
        $stat['DE'] = '276';
        $stat['GH'] = '288';
        $stat['GI'] = '292';
        $stat['KI'] = '296';
        $stat['GR'] = '300';
        $stat['GL'] = '304';
        $stat['GD'] = '308';
        $stat['GP'] = '312';
        $stat['GU'] = '316';
        $stat['GT'] = '320';
        $stat['GN'] = '324';
        $stat['GY'] = '328';
        $stat['HT'] = '332';
        $stat['HM'] = '334';
        $stat['VA'] = '336';
        $stat['HN'] = '340';
        $stat['HK'] = '344';
        $stat['HU'] = '348';
        $stat['IS'] = '352';
        $stat['IN'] = '356';
        $stat['ID'] = '360';
        $stat['IR'] = '364';
        $stat['IQ'] = '368';
        $stat['IE'] = '372';
        $stat['IL'] = '376';
        $stat['IT'] = '380';
        $stat['CI'] = '384';
        $stat['JM'] = '388';
        $stat['JP'] = '392';
        $stat['KZ'] = '398';
        $stat['JO'] = '400';
        $stat['KE'] = '404';
        $stat['KP'] = '408';
        $stat['KR'] = '410';
        $stat['KW'] = '414';
        $stat['KG'] = '417';
        $stat['LA'] = '418';
        $stat['LB'] = '422';
        $stat['LS'] = '426';
        $stat['LV'] = '428';
        $stat['LR'] = '430';
        $stat['LY'] = '434';
        $stat['LI'] = '438';
        $stat['LT'] = '440';
        $stat['LU'] = '442';
        $stat['MO'] = '446';
        $stat['MG'] = '450';
        $stat['MW'] = '454';
        $stat['MY'] = '458';
        $stat['MV'] = '462';
        $stat['ML'] = '466';
        $stat['MT'] = '470';
        $stat['MQ'] = '474';
        $stat['MR'] = '478';
        $stat['MU'] = '480';
        $stat['MX'] = '484';
        $stat['MC'] = '492';
        $stat['MN'] = '496';
        $stat['MD'] = '498';
        $stat['ME'] = '499';
        $stat['MS'] = '500';
        $stat['MA'] = '504';
        $stat['MZ'] = '508';
        $stat['OM'] = '512';
        $stat['NA'] = '516';
        $stat['NR'] = '520';
        $stat['NP'] = '524';
        $stat['NL'] = '528';
        $stat['AN'] = '530';
        $stat['AW'] = '533';
        $stat['NC'] = '540';
        $stat['VU'] = '548';
        $stat['NZ'] = '554';
        $stat['NI'] = '558';
        $stat['NE'] = '562';
        $stat['NG'] = '566';
        $stat['NU'] = '570';
        $stat['NF'] = '574';
        $stat['NO'] = '578';
        $stat['MP'] = '580';
        $stat['UM'] = '581';
        $stat['FM'] = '583';
        $stat['MH'] = '584';
        $stat['PW'] = '585';
        $stat['PK'] = '586';
        $stat['PA'] = '591';
        $stat['PG'] = '598';
        $stat['PY'] = '600';
        $stat['PE'] = '604';
        $stat['PH'] = '608';
        $stat['PN'] = '612';
        $stat['PL'] = '616';
        $stat['PT'] = '620';
        $stat['GW'] = '624';
        $stat['TL'] = '626';
        $stat['PR'] = '630';
        $stat['QA'] = '634';
        $stat['RE'] = '638';
        $stat['RO'] = '642';
        $stat['RU'] = '643';
        $stat['RW'] = '646';
        $stat['SH'] = '654';
        $stat['KN'] = '659';
        $stat['AI'] = '660';
        $stat['LC'] = '662';
        $stat['PM'] = '666';
        $stat['VC'] = '670';
        $stat['SM'] = '674';
        $stat['ST'] = '678';
        $stat['SA'] = '682';
        $stat['SN'] = '686';
        $stat['RS'] = '688';
        $stat['SC'] = '690';
        $stat['SL'] = '694';
        $stat['SG'] = '702';
        $stat['SK'] = '703';
        $stat['VN'] = '704';
        $stat['SI'] = '705';
        $stat['SO'] = '706';
        $stat['ZA'] = '710';
        $stat['ZW'] = '716';
        $stat['ES'] = '724';
        $stat['EH'] = '732';
        $stat['SD'] = '736';
        $stat['SR'] = '740';
        $stat['SJ'] = '744';
        $stat['SZ'] = '748';
        $stat['SE'] = '752';
        $stat['CH'] = '756';
        $stat['SY'] = '760';
        $stat['TJ'] = '762';
        $stat['TH'] = '764';
        $stat['TG'] = '768';
        $stat['TK'] = '772';
        $stat['TO'] = '776';
        $stat['TT'] = '780';
        $stat['AE'] = '784';
        $stat['TN'] = '788';
        $stat['TR'] = '792';
        $stat['TM'] = '795';
        $stat['TC'] = '796';
        $stat['TV'] = '798';
        $stat['UG'] = '800';
        $stat['UA'] = '804';
        $stat['MK'] = '807';
        $stat['EG'] = '818';
        $stat['GB'] = '826';
        $stat['GG'] = '831';
        $stat['JE'] = '832';
        $stat['IM'] = '833';
        $stat['TZ'] = '834';
        $stat['US'] = '840';
        $stat['VI'] = '850';
        $stat['BF'] = '854';
        $stat['UY'] = '858';
        $stat['UZ'] = '860';
        $stat['VE'] = '862';
        $stat['WF'] = '876';
        $stat['WS'] = '882';
        $stat['YE'] = '887';
        $stat['ZM'] = '894';
        return $stat;
    }
}
