<?php
/**
 * Backend pro Expressz.hu
 *
 * @category   Dalten
 * @package    Export
 * @subpackage Api
 */
class Dalten_Export_Api_Backend_Expresszhu
{
    private Serenity_Config_Config $_entities;
    private Dalten_Export_Expresszhu $_export;

    /**
	 * Konstruktor
	 *
	 * @param Dalten_Export_Expresszhu $export   Objekt exportu na spinavou praci.
	 * @param Serenity_Config_Config   $entities Objekt s nastavenim.
	 */
	public function __construct(Dalten_Export_Expresszhu $export, Serenity_Config_Config $entities)
	{
		$this->_export = $export;
		$this->_entities = $entities;
	}


	/**
	 * Připraví prázdné XML
	 *
	 * @return Dalten_Xml_SimpleXml
	 */
	public function prepareXml()
	{
		$xml = new Dalten_Xml_SimpleXml('<?xml version="1.0" encoding="UTF-8"?><ads/>');
		return $xml;
	}

	/**
	 * Přidá do XML jednu nemovitost.
	 *
	 * @param array  $xml    Sestavovane XML.
	 * @param array  $ad     Informace o nemovitosti ve formatu Irest 1.
	 * @param array  $user   Informace o makleri.
	 * @param array  $images Informace o obrazcich.
	 * @param string $userId Jméno uživatele Expressz.hu
	 * @param int    $index  Pořadí tagu v XML souboru.
	 */
	public function appendProperty(Dalten_Xml_SimpleXml $xml, $ad, $user, $images, $userId, $index)
	{
		$attrs = $this->_export->convertEntityValues('ad_meta', $ad, $this->_entities->ad_meta);
		$items = $this->_export->convertEntityValues('items', $ad, $this->_entities->items);
		$agentItems = $this->_export->convertEntityValues('agent', $user, $this->_entities->agent);

		$adXml = $xml->addChild('ad');
		$attrs['user-id'] = $userId;
		$attrs['index'] = $index;


		foreach ($attrs as $attrKey => $attrVal) {
			$adXml->addAttribute($attrKey, $attrVal);
		}

		$items = $items + $agentItems;

		foreach ($items as $itemKey => $itemVal) {
			$adXml->addChild('item', $itemVal)->addAttribute('codename', $itemKey);

		}

		//Za vic jak deset obrazku se priplaci.
		$images = array_slice($images, 0, 10);
		foreach ($images as $image) {
			$imageXml = $adXml->addChild('image');
			$imageXml->addAttribute('url', $image['url']);
			$imageXml->addAttribute('description', $image['popis']);
		}
		return true;
	}

	/**
	 * Připraví odebírací XML tag na nemovitost.
	 *
	 * @param Dalten_Xml_SimpleXml $xml    Sestavované XML
	 * @param array                $ad     Údaje o nemovitosti.
	 * @param array                $user   Údaje o uživateli
	 * @param array                $images Obrázky nemovitosti.
	 * @param $userId              $userId Číslo uživatele Expressz.hu.
	 * @param int                  $index  Pořadí tagu v XML.
	 *
	 * @return bool
	 */
	public function deleteProperty(Dalten_Xml_SimpleXml $xml, $ad, $user, $images, $userId, $index)
	{
		$adXml = $xml->addChild('ad');
		$attrs = $this->_export->convertEntityValues('ad_meta', $ad, $this->_entities->ad_meta);
		$attrs['user-id'] = $userId;
		$attrs['index'] = $index;

		foreach ($attrs as $attrKey => $attrVal) {
			$adXml->addAttribute($attrKey, $attrVal);
		}

		return true;
	}

	/**
	 * Uloží soubor s nemovitostmi.
	 *
	 * @param Dalten_Xml_SimpleXml $xml      XML objekt v paměti
	 * @param string               $fileName Název cílového souboru.
	 */
	public function saveToFile(Dalten_Xml_SimpleXml $xml, $fileName)
	{
		$data = $xml->asXML();
		$dom = new DOMDocument();
		$dom->loadXML($data);
		$dom->formatOutput = true;
		$formattedXML = $dom->saveXML();
		$written = file_put_contents($fileName, $formattedXML);
		if ($written === false) {
			return false;
		}
		return true;
	}

}