<?php
/**
 * Export (převodník hodnot) pro Nehnutelnosti.sk.
 *
 * @category Dalten
 * @package  Export
 */
class Dalten_Export_NehnutelnostiSk extends Dalten_Export_AbstractExport
{
	const ZEMEDELSKE_OBJEKTY = 1;
	const KOMERCNI_OBJEKTY = 2;
	const POZEMKY = 3;
	const BYTY = 4;
	const HISTORICKE_OBJEKTY = 5;
	const DOMY_A_VILY = 6;
	const HOTELY = 7;
	const NAJEMNI_DOMY = 8;
	const KOMERCNI_PROSTORY = 9;
	const CHATY = 10;
	const MALE_OBJEKTY = 11;

	/**
	 * Zařadí nemovitost do kategorie.
	 *
	 * @param array $values Informace o nemovitosti.
	 *
	 * @return int Číslo kategorie.
	 */
	protected function _idCategory(array $values)
	{
		$typ = $values['nemovitost_typ'];
		if ($typ==self::BYTY) {
			$dispozice = $values['nemovitost_dispozice'];
			/**
			1 	Garsoniéra
			2 	1+kk
			9 	1+1
			3 	2+kk
			10 	2+1
			4 	3+kk
			11 	3+1
			5 	4+kk
			12 	4+1
			6 	5+kk
			13 	5+1
			7 	6+kk
			14 	6+1
			8 	7+kk
			15 	7+1
			16 	Atypický
			17 	Jiný
			 */
			$dispozicePrevod = array(
				1 => 10000, // Garsónka
				2 => 10001, // 1 izbový byt
				9 => 10001, // 1 izbový byt
				3 => 10002, // 2 izbový byt
				10 => 10002, // 2 izbový byt
				4 => 10003, // 3 izbový byt
				11 => 10003, // 3 izbový byt,
				5 => 10004, // 4 izbový byt
				12 => 10004, // 4 izbový byt
				6 => 10005, // 5 a viac izbový byt
				13 => 10005, // 5 a viac izbový byt
				7 => 10005, // 5 a viac izbový byt
				14 => 10005, // 5 a viac izbový byt
				8 => 10005, // 5 a viac izbový byt
				15 => 10005, // 5 a viac izbový byt
			);
			if (isset($dispozicePrevod[$dispozice])) {
				return $dispozicePrevod[$dispozice];
			}
			return 10008; // Iný byt
		} elseif ($typ==self::DOMY_A_VILY) {
			return 20001; // Rodinný dom
		} elseif ($typ==self::CHATY) {
			return 30001; // Chata a chalupa
		} elseif ($typ==self::ZEMEDELSKE_OBJEKTY) {
			return 40014; // Poľnohosp. objekt
		} elseif ($typ==self::POZEMKY) {
			$druhPozemku = $values['nemovitost_druh_pozemku'];
			/**
			1 	Pro komerční výstavbu
			2 	Pro bydlení
			3 	Zemědělská
			4 	Les
			5 	Trvalý travní porost
			6 	Zahrada
			7 	Ostatní
			 */
			$druhyPozemkuPrevod = array(
				1 => 60006, // Komerčná zóna
				2 => 60001, // Pozemok pre rod. domy
				3 => 60010, // Orná pôda
				4 => 60014, // Lesy
				5 => 60012, // Lúka, pasienok
				6 => 60009, // Záhrada
			);
			if (isset($druhyPozemkuPrevod[$druhPozemku])) {
				return $druhyPozemkuPrevod[$druhPozemku];
			}
			return 60016; // Iný poľnohosp. pozemok
		} elseif ($typ==self::MALE_OBJEKTY) {
			return 40018; // Garáž
		} elseif ($typ==self::KOMERCNI_PROSTORY) {
			$druhProstor = $values['nemovitost_druh_prostor'];
			/**
			1 	Kanceláře
			2 	Obchodní
			3 	Skladovací
			4 	Jiné
			5 	Výrobní
			 */
			$druhyProstorPrevod = array(
				1 => 50001, // Kancelárie, admin. priestory
				2 => 50002, // Obchodné priestory
				3 => 50007, // Skladové priestory
				4 => 50005, // Iné komerčné priestory
				5 => 50006, // Výrobné priestory
			);
			if (isset($druhyProstorPrevod[$druhProstor])) {
				return $druhyProstorPrevod[$druhProstor];
			}
			return 50005;
		} elseif ($typ==self::KOMERCNI_OBJEKTY) {
			$ucelBudovy = $values['nemovitost_ucel_budovy'];
			/**
			1 	Sklad
			2 	Výroba
			3 	Obchodní centrum
			4 	Nákupní středisko
			5 	Průmyslový areál
			7 	Administrativní budova
			6 	Jiný
			 */
			$ucelyBudovyPrevod = array(
				1 => 40012, // Skladový objekt
				2 => 40011, // Výrobný objekt
				3 => 40005, // Objekt pre obchod
				4 => 40005, // Objekt pre obchod
				5 => 40013, // Prevádzkový areál
				7 => 40003, // Administratívny objekt
			);
			if (isset($ucelyBudovyPrevod[$ucelBudovy])) {
				return $ucelyBudovyPrevod[$ucelBudovy];
			}
			return 40022; // Iný objekt
		} elseif ($typ==self::HISTORICKE_OBJEKTY) {
			return 40021; // Historický objekt
		} elseif ($typ==self::HOTELY) {
			if ($values['nemovitost_typ_zarizeni']==3) {
				return 40006; // Reštaurácia
			} else {
				return 40007; // Hotel, penzión
			}
		} elseif ($typ==self::NAJEMNI_DOMY) {
			return 40001; // Nájomný dom
		}
		return 0;
	}

	/**
	 * Nechá projít jen URL vedoucí na Youtube.
	 *
	 * @param string $value URL ke kontrole.
	 *
	 * @return string|null Původní URL nebo NULL, pokud nevedla na Youtube.
	 */
	protected function _checkYoutube($value)
	{
		$parsedURL = parse_url($value);
		if ($parsedURL['host']=='youtu.be' || $parsedURL['host']=='www.youtube.com' || $parsedURL['host']=='youtube.com') {
			return $value;
		}
		return null;
	}

	/**
	 * {@inheritdoc}
	 */
	public function convertEntityValues($name, array $values, $config)
	{
		$values['idCategory'] = $this->_idCategory($values);
		if ($values['nemovitost_cena_pronajem_jednotka']==7) {
			// přepočítá pronájem za den na pronájem za měsíc
			$values['nemovitost_cena_pronajem'] = intval($values['nemovitost_cena_pronajem']) * 30;
			$values['nemovitost_cena_pronajem_jednotka'] = 2;
		}
		$values['youtube'] = $this->_checkYoutube($values['nemovitost_virtualni_prohlidka']);

		// plochy
		// poznámka k ceně
		return parent::convertEntityValues($name, $values, $config);
	}
}