<?php
/**
 * Export do formátu reality.idnes.
 *
 * @category   Dalten
 * @package    Export
 */
class Dalten_Export_RealitySk extends Dalten_Export_AbstractExport
{
	/**
	 * Převodní seznam typů a pod
	 * @var array
	 */
	private $_types = array();

	/**
	 * @see \Dalten_Export_AbstractExport::_format()
	 */
	protected function _format(array $values, $config, $entityName)
	{
		// mozna bude potreba
		return parent::_format($values, $config, $entityName);
	}

	/**
	 * Vrátí exportní typ dané nabídky.
	 *
	 * @param array  $codebook    Hodnoty z konfigu
	 * @param array  $listingData Hodnoty nabídky
	 * @return string
	 */
	public function getType($codebook, $listingData)
	{
		return $this->_getType($codebook, $listingData, 'type');
	}

	/**
	 * Vrátí exportní subtyp dané nabídky.
	 *
	 * @param array  $codebook    Hodnoty z konfigu
	 * @param array  $listingData Hodnoty nabídky
	 * @return string
	 */
	public function getSubType($codebook, $listingData)
	{
		return $this->_getType($codebook, $listingData, 'subtype');
	}

	/**
	 * Pomocná metoda vracející typ, nebo subtyp, podle požadavku (paramter $type)
	 *
	 * @param array  $codebook    Hodnoty z konfigu
	 * @param array  $listingData Hodnoty nabídky
	 * @param string $type        Požadovaný typ (type|subtype)
	 *
	 * @return string
	 */
	private function _getType($codebook, $listingData, $type = 'type')
	{
		if (empty($this->_types)) {
			$this->_parseTypes($codebook);
		}

		$listingType = (int) $listingData['nemovitost_typ'];
		$listingSubType = (int) $listingData['nemovitost_podtyp'];

		return $this->_types[$listingType][$listingSubType][$type];
	}

	/**
	 * Převede hodnoty z konfigu do požadované struktury
	 *
	 * @param array $codebook Hodnoty z konfigu
	 */
	private function _parseTypes($codebook)
	{
		foreach($codebook as $type => $sub) {
			foreach($sub as $subType => $toParse) {
				if (!isset($this->_types[$type])) {
					$this->_types[$type] = array();
				}
				$remoteVals = explode('|', $toParse);
				$this->_types[$type][$subType] = array(
					'type'    => $remoteVals[0],
					'subtype' => $remoteVals[1],
				);
			}
		}
	}
}
