<?php

namespace Dalten\WebBundle\Breadcrumbs\Company\Builder;

use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface;

/**
 * Builder na drobek, reprezentující statickou url.
 */
class StaticRoute implements BuilderInterface
{
	/**
	 * Konfigurace drobka.
	 *
	 * @var array
	 */
	private $_config;

	/**
	 * Nastavuje konfiguraci.
	 *
	 * Parametrem by mělo být pole s klíči: label, routeName a routeParams (pole).
	 *
	 * @param array $config Pole konfiguračních možností.
	 */
	public function __construct(array $config)
	{
		$this->_config = $config;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu nabídky.
	 *
	 * Na nabídku se v tomto případě nebere ohled, vrácený drobek ukazuje vždy na stejnou routu.
	 *
	 * @param Company $company Model firmy.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromCompany(Company $company)
	{
		return $this->_getBreadcrumb();
	}

	/**
	 * Vytvoří drobka z vyplněného filtru firem.
	 *
	 * Na filtr se v tomto případě nebere ohled, vrácený drobek ukazuje vždy na stejnou routu.
	 *
	 * @param CompanyFilter $filter Vyplněný filtr firem.
	 *
	 * @return BreadcrumbInterface|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(CompanyFilter $filter)
	{
		return $this->_getBreadcrumb();
	}

	/**
	 * Vytvoří model drobečku z configu a vrátí jej.
	 *
	 * @return null|BreadcrumbInterface Drobek nebo null pokud jej nelze vytvořit.
	 */
	private function _getBreadcrumb()
	{
		return new Breadcrumb(
			$this->_config['label'], $this->_config['routeName'], $this->_config['routeParams']
		);
	}
}
