<?php

namespace Dalten\WebBundle\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Breadcrumb;
use Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyAndRegionHelper;

/**
 * Tvořič drobečků na základě předchozího krajového drobečku a regionu.
 */
class PreviousBreadcrumbAndCountyAndRegion implements BuilderInterface
{
	/**
	 * Helper na tvorbu drobků s regionem.
	 *
	 * @var CountyAndRegionHelper
	 */
	private $_helper;

	/**
	 * Tvořič drobku s krajem.
	 *
	 * @var PreviousBreadcrumbAndCounty
	 */
	private $_countyBreadcrumbBuilder;

	/**
	 * Nastavuje konfiguraci.
	 *
	 * @param PreviousBreadcrumbAndCounty $countyBreadcrumbBuilder Tvořič drobku s krajem.
	 * @param CountyAndRegionHelper       $helper Helper na tvorbu drobků s regionem.
	 */
	public function __construct(PreviousBreadcrumbAndCounty $countyBreadcrumbBuilder, CountyAndRegionHelper $helper)
	{
		$this->_helper = $helper;
		$this->_countyBreadcrumbBuilder = $countyBreadcrumbBuilder;
	}

	/**
	 * Vytvoří drobka z vyplněného modelu nabídky.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param Listing $listing Model nabídky.
	 *
	 * @return Breadcrumb|null Drobek nebo null.
	 */
	public function getBreadcrumbFromListing(Listing $listing)
	{
		$previousBreadcrumb = $this->_countyBreadcrumbBuilder->getBreadcrumbFromListing($listing);

		if ($previousBreadcrumb === null) {
			return null;
		}

		return $this->_helper->getBreadcrumb(
			$previousBreadcrumb,
			array($listing->listing_locality_county_code),
			$listing->listing_locality_prague_district_code ? : $listing->listing_locality_region_code
		);
	}

	/**
	 * Vytvoří drobka z vyplněného filtru nabídek.
	 *
	 * Pokud se pro dané údaje nepodaří drobek vytvořit, vrátí null.
	 *
	 * @param ListingFilter $filter Vyplněný filtr nabídek.
	 *
	 * @return Breadcrumb|null Drobek nebo null.
	 */
	public function getBreadcrumbFromFilter(ListingFilter $filter)
	{
		$previousBreadcrumb = $this->_countyBreadcrumbBuilder->getBreadcrumbFromFilter($filter);

		if ($previousBreadcrumb) {
			return $this->_helper->getBreadcrumbFromFilter($filter, $previousBreadcrumb);
		}

		return null;
	}
}
