<?php
namespace Dalten\WebBundle\DependencyInjection\Feature;

use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 14.04.2016
 * Time: 10:58
 */
class ListingListSeoRoutes implements FeatureInterface, FeatureWithCompilerPassInterface
{
	private $_config = [];
	private $_routeDefinitions = [];

	public function load(array $featureConfig, ContainerBuilder $container)
	{
		$loader = new YamlFileLoader(
			$container,
			new FileLocator(__DIR__ . '/../../Resources/config/feature/listing_seo_routes')
		);
		$loader->load('config.yml');

		$czechLocaleEnabled = in_array('cs', $featureConfig['locales']);
		$englishLocaleEnabled = in_array('en', $featureConfig['locales']);

		if (empty($featureConfig['route_definitions'])) {
			$loader->load('default_route_definitions.yml');
			$this->_routeDefinitions = $container
				->getParameter('seo_route.matcher.listing_filter.collection.route_definitions');
			if ($czechLocaleEnabled) {
				$loader->load('default_matchers_cs.yml');
			}
			if ($englishLocaleEnabled) {
				$loader->load('default_matchers_en.yml');
			}
		}

		$this->_config = $featureConfig;
	}

	/**
	 * You can modify the container here before it is dumped to PHP code.
	 *
	 * @param ContainerBuilder $container
	 */
	public function executeCompilerPass(ContainerBuilder $container)
	{
		$czechLocaleEnabled = in_array('cs', $this->_config['locales']);
		$englishLocaleEnabled = in_array('en', $this->_config['locales']);

		$czechMatchers = $englishMatchers = [];
		$taggedServices = $container->findTaggedServiceIds('seo_route_matcher');
		foreach ($taggedServices as $id => $tags) {
			foreach ($tags as $attributes) {
				if (empty($attributes['lang'])) {
					throw new InvalidConfigurationException(
						sprintf(
							'DI tag "seo_route_matcher" for service "%s" is missing required parameter "locale".',
							$id
						)
					);
				}

				if ($attributes['lang'] === 'en') {
					$englishMatchers[] = new Reference($id);
				} elseif ($attributes['lang'] === 'cs') {
					$czechMatchers[] = new Reference($id);
				}
			}
		}

		$matchers = [];

		if ($czechLocaleEnabled) {
			$definition = $container->findDefinition('listing_seo_route_matcher.cs');
			$definition->setArguments([$this->_config['route_definitions'], $czechMatchers]);
			$matchers['cs'] = new Reference('listing_seo_route_matcher.cs');
		} else {
			$container->removeDefinition('listing_seo_route_matcher.cs');
		}

		if ($englishLocaleEnabled) {
			$definition = $container->findDefinition('listing_seo_route_matcher.en');
			$definition->setArguments([$this->_config['route_definitions'], $englishMatchers]);
			$matchers['en'] = new Reference('listing_seo_route_matcher.en');
		} else {
			$container->removeDefinition('listing_seo_route_matcher.en');
		}

		if ($matchers) {
			$definition = $container->findDefinition('listing_seo_route_redirect_response_generator');
			$definition->replaceArgument(1, $matchers);
			if (!empty($featureConfig['ignored_query_params'])) {
				$definition->replaceArgument(2, $featureConfig['ignored_query_params']);
			}
		} else {
			$container->removeDefinition('listing_seo_route_redirect_response_generator');
		}
	}
}
