<?php
namespace Dalten\WebBundle\Entity;

/**
 * @property int $id
 * @property string $name
 * @property string $email
 * @property string $invoice_address_name
 * @property string $invoice_address_street
 * @property string $invoice_address_city
 * @property string $invoice_address_zip
 * @property string $invoice_address_state
 * @property string $invoice_address_ir
 * @property string $invoice_address_vat_in
 * @property string $phone
 * @property string $fax
 * @property string $self_promo
 * @property string $office_description
 * @property string $office_description_en
 * @property string $office_logo
 * @property string $office_web_url
 * @property integer $company_category
 * @property integer $region_code
 * @property integer $city_code
 * @property integer $county_code
 * @property string $slug
 * @property array $mortgage_broker_list
 * @property array $lawyer_list
 * @property string $franchise_name
 * @property string $deposit_account_number
 * @property boolean $receive_copy_from_contact_forms
 * @property integer $court_name
 * @property integer $court_section
 * @property integer $court_insert
 * @property string $headquarters_street
 * @property string $headquarters_city
 * @property string $headquarters_zip
 * @property string $company_gpx_x
 * @property string $company_gpx_y
 * @property string $seznam_retargeting_id
 * @property string $google_analytics_id
 * @property string $google_retargeting_id
 * @property string $seo_text
 * @property string $image_alt_text
 */
class Company implements EntityWithLegacyData
{
    use LegacyDataMethods;

    /**
     * @var int
     */
    private $id;

    /**
     * @var string
     */
    private $_nazev;

    /**
     * @var string
     */
    private $_email;

    /**
     * @var integer
     */
    private $_cenovy_program;

    /**
     * @var integer
     */
    private $_pocet_uzivatel_navic;

    /**
     * @var integer
     */
    private $_platebni_obdobi_od;

    /**
     * @var integer
     */
    private $_platebni_obdobi;

    /**
     * @var \DateTime
     */
    private $_registrace;

    /**
     * @var \DateTime
     */
    private $_registrace_do;

    /**
     * @var string
     */
    private $_fakt_jmeno;

    /**
     * @var string
     */
    private $_fakt_ulice;

    /**
     * @var string
     */
    private $_fakt_mesto;

    /**
     * @var string
     */
    private $_fakt_psc;

    /**
     * @var string
     */
    private $_fakt_stat;

    /**
     * @var string
     */
    private $_fakt_ic;

    /**
     * @var string
     */
    private $_fakt_dc;

    /**
     * @var string
     */
    private $_www;

    /**
     * @var string
     */
    private $_telefon;

    /**
     * @var string
     */
    private $_fax;

    /**
     * @var string
     */
    private $_photoid_ilist;

    /**
     * @var string
     */
    private $_bulletpoint;

    /**
     * @var string
     */
    private $_closer;

    /**
     * @var string
     */
    private $_officedescription;

    /**
     * @var string
     */
    private $_officedescription_en;

    /**
     * @var string
     */
    private $_officepicture;

    /**
     * @var string
     */
    private $_poznamka;

    /**
     * @var integer
     */
    private $_okres;

    /**
     * @var integer
     */
    private $_mesto;

    /**
     * @var integer
     */
    private $_kraj;

    /**
     * @var string
     */
    private $_link;

    /**
     * @var blob
     */
    private $_hypotecni_makleri;

    /**
     * @var blob
     */
    private $_advokati;

    /**
     * @var string
     */
    private $_fransiza_jmeno;

    /**
     * @var string
     */
    private $_depozitni_ucet;

    /**
     * @var string
     */
    private $_firma_gps_x;

    /**
     * @var string
     */
    private $_firma_gps_y;

    /**
     * @var string
     */
    private $_suggest_fulltext;

    /**
     * @var integer
     */
    private $_or_soud_nazev;

    /**
     * @var integer
     */
    private $_or_soud_oddil;

    /**
     * @var integer
     */
    private $_or_soud_vlozka;

    /**
     * @var string
     */
    private $_or_sidlo_ulice;

    /**
     * @var string
     */
    private $_or_sidlo_mesto;

    /**
     * @var string
     */
    private $_or_sidlo_psc;

    /**
     * @var string
     */
    private $_firma_seo_lokalita;

    /**
     * @var string
     */
    private $_firma_google_analytics;

    /**
     * @var string
     */
    private $_firma_seznam_retargeting_id;

    /**
     * @var boolean
     */
    private $_posilat_kopie_dotazu_na_mail_rk;

    /**
     * @var string
     */
    private $_suggest_detail;

    /**
     * @var string
     */
    private $_firma_google_retargeting_id;

    /**
     * @var string
     */
    private $_firma_seo_text;

    /**
     * @var string
     */
    private $_firma_alt_text;

    private static $_map = array(
        'id' => '_id',
        'name' => '_nazev',
        'email' => '_email',
        'invoice_address_name' => '_fakt_jmeno',
        'invoice_address_street' => '_fakt_ulice',
        'invoice_address_city' => '_fakt_mesto',
        'invoice_address_zip' => '_fakt_psc',
        'invoice_address_state' => '_fakt_stat',
        'invoice_address_ir' => '_fakt_ic',
        'invoice_address_vat_in' => '_fakt_dc',
        'phone' => '_telefon',
        'fax' => '_fax',
        'self_promo' => '_bulletpoint',
        'office_description' => '_officedescription',
        'office_description_en' => '_officedescription_en',
        'office_logo' => '_officepicture',
        'office_web_url' => '_www',
        'region_code' => '_okres',
        'city_code' => '_mesto',
        'county_code' => '_kraj',
        'slug' => '_link',
        'mortgage_broker_list' => '_hypotecni_makleri',
        'lawyer_list' => '_advokati',
        'franchise_name' => '_fransiza_jmeno',
        'deposit_account_number' => '_depozitni_ucet',
        'receive_copy_from_contact_forms' => '_posilat_kopie_dotazu_na_mail_rk',
        'court_name' => '_or_soud_nazev',
        'court_section' => '_or_soud_oddil',
        'court_insert' => '_or_soud_vlozka',
        'headquarters_street' => '_or_sidlo_ulice',
        'headquarters_city' => '_or_sidlo_mesto',
        'headquarters_zip' => '_or_sidlo_psc',
        'company_gpx_x' => '_firma_gps_x',
        'company_gpx_y' => '_firma_gps_y',
        'seznam_retargeting_id' => '_firma_seznam_retargeting_id',
        'google_analytics_id' => '_firma_google_analytics',
        'google_retargeting_id' => '_firma_google_retargeting_id',
        'seo_text' => '_firma_seo_text',
        'image_alt_text' => '_firma_alt_text',
    );
}
