<?php
namespace Dalten\WebBundle\Entity;

use Dalten\WebBundle\Entity\Exception\InvalidLocaleException;

/**
 * Entita projektu.
 *
 * @property int                 $id
 * @property int                 $client_id
 * @property int                 $company_branch_id
 * @property int                 $company_id
 * @property int                 $user_id
 * @property string              $advert_code
 * @property int                 $advert_number
 * @property int                 $advert_active
 * @property \DateTime           $project_building_approval_date
 * @property \DateTime           $project_move_in_date
 * @property string              $project_name
 * @property string              $project_name_en
 * @property string              $project_stages
 * @property string              $project_stages_en
 * @property string              $project_description
 * @property string              $project_description_en
 * @property \DateTime           $project_building_permit_date
 * @property \DateTime           $project_construct_completion_date
 * @property \DateTime           $project_planning_decision_date
 * @property \DateTime           $project_sale_date
 * @property \DateTime           $project_construct_start_date
 * @property string              $project_annotation
 * @property int                 $project_locality_municipality_part_code
 * @property string              $project_locality_municipality_part
 * @property int                 $project_locality_county_code
 * @property string              $project_locality_county
 * @property int                 $project_locality_city_part_code
 * @property string              $project_locality_city_part
 * @property int                 $project_locality_municipality_code
 * @property string              $project_locality_municipality
 * @property int                 $project_locality_region_code
 * @property string              $project_locality_region
 * @property int                 $project_locality_prague_district_code
 * @property string              $project_locality_prague_district
 * @property int                 $project_locality_street_code
 * @property string              $project_locality_street
 * @property string              $listing_locality_country_code
 * @property int                 $advert_contract_type
 * @property \DateTime           $edited
 * @property \DateTime           $created
 * @property int                 $advert_min_listing_price
 * @property int                 $advert_max_listing_price
 * @property ListingAttachment[] $attachments Přílohy.
 * @property Listing[]           $listings    Nabídky projektu.
 * @property Broker              $broker      Makléř nabídky.
 * @property string              $project_locality_description
 * @property string              $project_locality_description_en
 * @property string              $flats_min_price
 * @property string              $houses_min_price
 * @property int                 $flats_count
 * @property int                 $houses_count
 * @property int                 $garage
 * @property string              $heating
 * @property string              $transportation
 * @property string              $water_supply
 * @property string              $drains
 * @property string              $telecommunication
 * @property string              $other_wiring
 * @property string              $electricity
 * @property string              $locality_latitude
 * @property string              $locality_longitude
 */
class DevProject implements EntityWithLegacyData
{
	use LegacyDataMethods;

	/**
	 * @var int
	 */
	private $id;

	/**
	 * @var int
	 */
	private $_id_klient;

	/**
	 * @var int
	 */
	private $_id_firma;

	/**
	 * @var int
	 */
	private $_id_pobocka;

	/**
	 * @var int
	 */
	private $_id_team;

	/**
	 * @var int
	 */
	private $_id_uzivatel;

	/**
	 * @var string
	 */
	private $_kod;

	/**
	 * @var int
	 */
	private $_cislo;

	/**
	 * @var int
	 */
	private $_projekt_aktivni;

	/**
	 * @var \DateTime
	 */
	private $_projekt_dokonceni_hrube_stavby;

	/**
	 * @var \DateTime
	 */
	private $_projekt_kolaudace;

	/**
	 * @var \DateTime
	 */
	private $_projekt_k_nastehovani;

	/**
	 * @var string
	 */
	private $_projekt_nazev;

	/**
	 * @var string
	 */
	private $_projekt_nazev_en;

	/**
	 * @var string
	 */
	private $_projekt_popis;

	/**
	 * @var string
	 */
	private $_projekt_popis_en;

	/**
	 * @var \DateTime
	 */
	private $_projekt_stavebni_povoleni;

	/**
	 * @var \DateTime
	 */
	private $_projekt_ukonceni_stavby;

	/**
	 * @var \DateTime
	 */
	private $_projekt_uzemni_rozhodnuti;

	/**
	 * @var \DateTime
	 */
	private $_projekt_zahajeni_prodeje;

	/**
	 * @var \DateTime
	 */
	private $_projekt_zahajeni_stavby;

	/**
	 * @var string
	 */
	private $_projekt_zakladni_popis;

	/**
	 * @var string
	 */
	private $_projekt_zakladni_popis_en;

	/**
	 * @var int
	 */
	private $_nemovitost_uir_cobce_kod;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_cobce_text;

	/**
	 * @var int
	 */
	private $_nemovitost_uir_kraj_kod;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_kraj_text;

	/**
	 * @var int
	 */
	private $_nemovitost_uir_mcast_kod;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_mcast_text;

	/**
	 * @var int
	 */
	private $_nemovitost_uir_obec_kod;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_obec_text;

	/**
	 * @var int
	 */
	private $_nemovitost_uir_okres_kod;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_okres_text;

	/**
	 * @var int
	 */
	private $_nemovitost_uir_pobvod_kod;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_pobvod_text;

	/**
	 * @var int
	 */
	private $_nemovitost_uir_ulice_kod;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_ulice_text;

	/**
	 * @var string
	 */
	private $_nemovitost_uir_stat;

	/**
	 * @var string
	 */
	private $_nabidka_gps_x;

	/**
	 * @var string
	 */
	private $_nabidka_gps_y;

	/**
	 * @var boolean
	 */
	private $_nabidka_gps_presnost;

	/**
	 * @var int
	 */
	private $_zakazka_typ_smlouvy;

	/**
	 * @var datetime
	 */
	private $_zakazka_datum_editace;

	/**
	 * @var datetime
	 */
	private $_zakazka_datum_vlozeno;

	/**
	 * @var string
	 */
	private $_zakazka_makler;

	/**
	 * @var string
	 */
	private $_zakazka_makler_upravil;

	/**
	 * @var int
	 */
	private $_zakladni_vklad;

	/**
	 * @var int
	 */
	private $_komercni_plochy_pocet;

	/**
	 * @var string
	 */
	private $_dvere;

	/**
	 * @var string
	 */
	private $_fasadni_omitky;

	/**
	 * @var int
	 */
	private $_pocet_bytu;

	/**
	 * @var int
	 */
	private $_garaze;

	/**
	 * @var int
	 */
	private $_pocet_domu;

	/**
	 * @var string
	 */
	private $_investor_mesto;

	/**
	 * @var string
	 */
	private $_investor_stat;

	/**
	 * @var string
	 */
	private $_investor_email;

	/**
	 * @var string
	 */
	private $_investor_fax;

	/**
	 * @var string
	 */
	private $_investor_nazev;

	/**
	 * @var string
	 */
	private $_investor_telefon;

	/**
	 * @var string
	 */
	private $_investor_ulice;

	/**
	 * @var string
	 */
	private $_investor_www;

	/**
	 * @var int
	 */
	private $_investor_psc;

	/**
	 * @var int
	 */
	private $_kuchynska_linka;

	/**
	 * @var string
	 */
	private $_klempirina;

	/**
	 * @var string
	 */
	private $_krytina;

	/**
	 * @var int
	 */
	private $_byty_max_plocha;

	/**
	 * @var int
	 */
	private $_kancelare_max_plocha;

	/**
	 * @var int
	 */
	private $_komercni_plochy_max_plocha;

	/**
	 * @var int
	 */
	private $_byty_max_cena;

	/**
	 * @var int
	 */
	private $_domy_min_cena;

	/**
	 * @var int
	 */
	private $_projekt_cena_max;

	/**
	 * @var int
	 */
	private $_projekt_cena_min;

	/**
	 * @var int
	 */
	private $_domy_max_cena;

	/**
	 * @var int
	 */
	private $_domy_min_plocha;

	/**
	 * @var int
	 */
	private $_domy_max_plocha;

	/**
	 * @var int
	 */
	private $_max_house_volume;

	/**
	 * @var int
	 */
	private $_kancelare_max_cena;

	/**
	 * @var int
	 */
	private $_komercni_plochy_min_plocha;

	/**
	 * @var int
	 */
	private $_byty_min_cena;

	/**
	 * @var int
	 */
	private $_min_house_volume;

	/**
	 * @var int
	 */
	private $_kancelare_min_cena;

	/**
	 * @var int
	 */
	private $_hypoteka;

	/**
	 * @var string
	 */
	private $_hypotecni_ustav;

	/**
	 * @var float
	 */
	private $_hypoteka_procenta;

	/**
	 * @var int
	 */
	private $_pocet_objektu;

	/**
	 * @var int
	 */
	private $_pocet_kancelari;

	/**
	 * @var string
	 */
	private $_okna;

	/**
	 * @var string
	 */
	private $_ostatni_plochy;

	/**
	 * @var int
	 */
	private $_pocet_mist_k_parkovani;

	/**
	 * @var int
	 */
	private $_projekt_ov;

	/**
	 * @var string
	 */
	private $_podlahy;

	/**
	 * @var string
	 */
	private $_projekt_lokalita;

	/**
	 * @var string
	 */
	private $_projekt_lokalita_en;

	/**
	 * @var int
	 */
	private $_region_id;

	/**
	 * @var string
	 */
	private $_schody;

	/**
	 * @var int
	 */
	private $_byty_min_plocha;

	/**
	 * @var int
	 */
	private $_kancelare_min_plocha;

	/**
	 * @var float
	 */
	private $_stavebni_sporeni_procenta;

	/**
	 * @var string
	 */
	private $_etapy;

	/**
	 * @var string
	 */
	private $_strecha;

	/**
	 * @var string
	 */
	private $_stropy;

	/**
	 * @var string
	 */
	private $_vnejsi_obklady;

	/**
	 * @var string
	 */
	private $_vnitrni_obklady;

	/**
	 * @var string
	 */
	private $_vnitrni_omitky;

	/**
	 * @var string
	 */
	private $_zaklady;

	/**
	 * @var string
	 */
	private $_nemovitost_topeni;

	/**
	 * @var string
	 */
	private $_nemovitost_plyn;

	/**
	 * @var string
	 */
	private $_nemovitost_doprava;

	/**
	 * @var string
	 */
	private $_nemovitost_voda;

	/**
	 * @var string
	 */
	private $_nemovitost_odpad;

	/**
	 * @var array
	 */
	private $_nemovitost_telekomunikace;

	/**
	 * @var array
	 */
	private $_nemovitost_ostatni_rozvody;

	/**
	 * @var array
	 */
	private $_nemovitost_elektrina;

	/**
	 * @var int
	 */
	private $_projekt_psc;

	/**
	 * @var string
	 */
	private $_developer_mesto;

	/**
	 * @var string
	 */
	private $_developer_stat;

	/**
	 * @var string
	 */
	private $_developer_email;

	/**
	 * @var string
	 */
	private $_developer_fax;

	/**
	 * @var string
	 */
	private $_developer_nazev;

	/**
	 * @var string
	 */
	private $_developer_telefon;

	/**
	 * @var string
	 */
	private $_developer_ulice;

	/**
	 * @var string
	 */
	private $_developer_www;

	/**
	 * @var int
	 */
	private $_developer_psc;

	/**
	 * @var array
	 */
	private $_nemovitost_obcanska_vybavenost;

	/**
	 * @var string
	 */
	private $_projekt_etapy;

	/**
	 * @var string
	 */
	private $_projekt_etapy_en;

	/**
	 * @var DevProjectAttachment[]
	 */
	private $attachments;

	/**
	 * @var Listing[]
	 */
	private $listings;

	/**
	 * @var Broker
	 */
	private $broker;

	private static $_map = [
		'listings' => 'listings',
		'broker' => 'broker',
		'client_id' => '_id_klient',
		'company_branch_id' => '_id_pobocka',
		'company_id' => '_id_firma',
		'user_id' => '_id_uzivatel',
		'advert_code' => '_kod',
		'advert_number' => '_cislo',
		'advert_active' => '_projekt_aktivni',
		'project_building_approval_date' => '_projekt_kolaudace',
		'project_move_in_date' => '_projekt_k_nastehovani',
		'project_name' => '_projekt_nazev',
		'project_name_en' => '_projekt_nazev_en',
		'project_description' => '_projekt_popis',
		'project_description_en' => '_projekt_popis_en',
		'project_building_permit_date' => '_projekt_stavebni_povoleni',
		'project_construct_completion_date' => '_projekt_ukonceni_stavby',
		'project_planning_decision_date' => '_projekt_uzemni_rozhodnuti',
		'project_sale_date' => '_projekt_zahajeni_prodeje',
		'project_construct_start_date' => '_projekt_zahajeni_stavby',
		'project_annotation' => '_projekt_zakladni_popis',
		'project_annotation_en' => '_projekt_zakladni_popis_en',
		'project_stages' => '_projekt_etapy',
		'project_stages_en' => '_projekt_etapy_en',
		'project_locality_municipality_part_code' => '_nemovitost_uir_cobce_kod',
		'project_locality_municipality_part' => '_nemovitost_uir_cobce_text',
		'project_locality_county_code' => '_nemovitost_uir_kraj_kod',
		'project_locality_county' => '_nemovitost_uir_kraj_text',
		'project_locality_city_part_code' => '_nemovitost_uir_mcast_kod',
		'project_locality_city_part' => '_nemovitost_uir_mcast_text',
		'project_locality_municipality_code' => '_nemovitost_uir_obec_kod',
		'project_locality_municipality' => '_nemovitost_uir_obec_text',
		'project_locality_region_code' => '_nemovitost_uir_okres_kod',
		'project_locality_region' => '_nemovitost_uir_okres_text',
		'project_locality_prague_district_code' => '_nemovitost_uir_pobvod_kod',
		'project_locality_prague_district' => '_nemovitost_uir_pobvod_text',
		'project_locality_street_code' => '_nemovitost_uir_ulice_kod',
		'project_locality_street' => '_nemovitost_uir_ulice_text',
		'listing_locality_country_code' => '_nemovitost_uir_stat',
		'advert_contract_type' => '_zakazka_typ_smlouvy',
		'edited' => '_zakazka_datum_editace',
		'created' => '_zakazka_datum_vlozeno',
		'advert_min_listing_price' => '_projekt_cena_min',
		'advert_max_listing_price' => '_projekt_cena_max',
		'project_locality_description' => '_projekt_lokalita',
		'project_locality_description_en' => '_projekt_lokalita_en',
        'flats_min_price' => '_byty_min_cena',
        'houses_min_price' => '_domy_min_cena',
        'flats_count' => '_pocet_bytu',
        'houses_count' => '_pocet_domu',
        'garage' => '_garaze',
        'heating' => '_nemovitost_topeni',
        'transportation' => '_nemovitost_doprava',
        'water_supply' => '_nemovitost_voda',
        'drains' => '_nemovitost_odpad',
        'telecommunication' => '_nemovitost_telekomunikace',
        'other_wiring' => '_nemovitost_ostatni_rozvody',
        'electricity' => '_nemovitost_elektrina',
        'locality_latitude' => '_nabidka_gps_x',
        'locality_longitude' => '_nabidka_gps_y',
	];

	/**
	 * Získá obrázky nabídky.
	 *
	 * @return ListingAttachment[]
	 */
	public function getImages()
	{
		$ret = [];
		foreach ($this->attachments as $attachment) {
			if ($attachment->isImage()) {
				$ret[] = $attachment;
			}
		}

		usort($ret, function ($firstAttachment, $secondAttachment) {
			/** @var ListingAttachment $firstAttachment */
			/** @var ListingAttachment $secondAttachment */
			$first = $firstAttachment->order;
			$second = $secondAttachment->order;

			if ($first == $second) {
				return 0;
			}

			return $first > $second ? 1 : -1;
		});

		return $ret;
	}

	/**
	 * Vrátí popis v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný popis.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedDescription($locale)
	{
		return $this->_getLocalizedProperty('project_description', $locale);
	}

	/**
	 * Vrátí název projektu v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný název projektu.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedName($locale)
	{
		return $this->_getLocalizedProperty('project_name', $locale);
	}

	/**
	 * Vrátí popis etap v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný popis etap.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedStageDescription($locale)
	{
		return $this->_getLocalizedProperty('project_stages', $locale);
	}

	/**
	 * Vrátí popis lokality v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný popis lokality.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedLocalityDescription($locale)
	{
		return $this->_getLocalizedProperty('project_locality_description', $locale);
	}

	/**
	 * Vrátí krátký popis v jazyce dle předané locale.
	 *
	 * @param string $locale Dvoupísmenná locale (cs, en).
	 *
	 * @return string Lokalizovaný krátký popis.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	public function getLocalizedAnnotation($locale)
	{
		return $this->_getLocalizedProperty('project_annotation', $locale);
	}

    /**
     * Vrátí nejnižší nenulovou cenu nemovitosti z projektu.
     *
     * @return mixed Cena
     */
    public function getLowestPrice() {
        $allPrices = [$this->_projekt_cena_min, $this->_byty_min_cena, $this->_domy_min_cena];

        foreach ($allPrices as $key => $price) {
            if ($price == 0) {
                unset($allPrices[$key]);
            }
        }

        asort($allPrices);

        return current($allPrices);
    }

	/**
	 * Vrátí hodnotu vlastnosti na základě názvu české vlastnosti a locale.
	 *
	 * @param string $propertyName Název vlastnosti v českém tvaru (bez suffixu).
	 * @param string $locale       Dvoupísmenná locale (cs, en).
	 *
	 * @return mixed Hodnota dané vlastnosti.
	 *
	 * @throws InvalidLocaleException Pokud není locale podporována.
	 */
	private function _getLocalizedProperty($propertyName, $locale)
	{
		if ($locale === 'en') {
			$propertyName .= '_en';
		} elseif ($locale !== 'cs') {
			throw new InvalidLocaleException(sprintf('Nepodporovaná locale "%s"', $locale));
		}

		return $this->$propertyName;
	}
}
