<?php
namespace Dalten\WebBundle\Entity;

use Dalten\WebBundle\Entity\Exception\InvalidLegacyPropertyException;

/**
 * Created by PhpStorm.
 * User: karel
 * Date: 08.12.2015
 * Time: 14:52
 */
interface EntityWithLegacyData
{
	/**
	 * Získá hodnotu "staré" (z DB) proměnné.
	 *
	 * @param string $property název "staré" proměnné.
	 *
	 * @return mixed Hodnota proměnné.
	 *
	 * @throws InvalidLegacyPropertyException Pokud $property není legacy vlastností.
	 */
	public function getLegacyProperty($property);

	/**
	 * Zjistí, zda existuje daná "stara" (z DB) proměnná. Alternativa isset.
	 *
	 * @param string $property název "staré" proměnné.
	 *
	 * @return bool Existuje tato legacy proměnná?
	 */
	public function hasLegacyProperty($property);

	/**
	 * Nastaví hodnotu "staré" (z DB) proměnné.
	 *
	 * @param string $property Název "staré" proměnné.
	 * @param mixed  $value    Hodnota proměnné.
	 *
	 * @return $this
	 *
	 * @throws InvalidLegacyPropertyException Pokud $property není legacy vlastností.
	 */
	public function setLegacyProperty($property, $value);
}
