<?php
namespace Dalten\WebBundle\Processor;

/**
 * Rozhraní pro stránkovač.
 */
interface PaginatorIterface
{
	/**
	 * Určuje zda se mají načíst všechny položky bez ohledu na stránkování.
	 *
	 * @param bool $loadAll True pokud se mají načíst všechny položky, jinak false.
	 *
	 * @return self Fluent interface.
	 */
	public function setLoadAllRecords($loadAll);

	/**
	 * Vrátí aktuální stránku záznamu.
	 *
	 * @return integer
	 */
	public function getCurrent();

	/**
	 * Nastaví aktuální stránku.
	 *
	 * @param integer $current Číslo aktuální stránky.
	 *
	 * @return self
	 */
	public function setCurrent($current);

	/**
	 * Vrátí celkový počet záznamů v úložišti.
	 *
	 * @return integer
	 */
	public function getRecordCount();

	/**
	 * Nastaví počet záznamů v úložišti.
	 *
	 * @param integer $recordCount Číslo celkového počtu záznamů v úložišti.
	 *
	 * @return self
	 */
	public function setRecordCount($recordCount);

	/**
	 * Vrátí požadovaný počet záznamů na stránku.
	 *
	 * @return integer
	 */
	public function getRecordsOnPage();

	/**
	 * Nastaví požadovaný počet záznamů na stránku.
	 *
	 * @param integer $recordsOnPage Požadovaný počet záznamů na stránku.
	 *
	 * @return self
	 */
	public function setRecordsOnPage($recordsOnPage);

	/**
	 * Vrátí vypočtené číslo stránky v úložišti.
	 *
	 * @return integer
	 */
	public function getOffset();

	/**
	 * Vrátí vypočtený počet stránek v úložišti.
	 *
	 * @return integer
	 */
	public function getPageCount();

	/**
	 * Nastaví povolený počet záznamů na stránku.
	 *
	 * Pokud je nastaveno prázdné pole, není počet záznamů na stránku omezen.
	 *
	 * @param array $allowedRecordsOnPage Počet povolených záznamů na stránku (třeba [10, 20, 30]).
	 *
	 * @return \Dalten\Processor\Paginator Fluent interface.
	 */
	public function setAllowedRecordsOnPage(array $allowedRecordsOnPage);

	/**
	 * Vrátí povolený počet záznamů na stránku.
	 *
	 * @return array Počet povolených záznamů na stránku (třeba [10, 20, 30]).
	 */
	public function getAllowedRecordsOnPage();
}
