<?php
namespace Dalten\WebBundle\Processor\SeoUrl;

/**
 * Helper na změnu pořadí parametrů routy tak, aby byla routa v canonical tvaru.
 */
class CanonicalQueryParamsGenerator
{
	/**
	 * Pole názvů parametrů z query, které jsou povoleny - ostatní jsou z query odstraněny.
	 *
	 * @var array
	 */
	private $_allowedQueryFields;

	/**
	 * Nastavuje config.
	 *
	 * @param array $allowedQueryFields Pole názvů povolených parametrů z query, ostatní jsou ignorovány.
	 */
	public function __construct(array $allowedQueryFields)
	{
		$this->_allowedQueryFields = $allowedQueryFields;
	}

	/**
	 * Vrátí parametry pro routu, která bude mít query parametry v canonical tvaru.
	 *
	 * Pokud parametry již v canonical tvaru jsou, vrátí null.
	 *
	 * @param array $requestQuery      Parametry z query.
	 * @param array $requestAttributes Atributy z requestu.
	 *
	 * @return array|null Pole parametrů pro routu v canonical tvaru a nebo null pokud routa již canonical je.
	 */
	public function getCanonicalQueryParamsForRedirect(array $requestQuery, array $requestAttributes)
	{
		$canonicalQueryParams = $requestQuery;

		foreach (array_keys($requestAttributes) as $paramName) {
			if (strpos($paramName, '_') === 0) {
				unset($requestAttributes[$paramName]);
			}
		}

		foreach (array_keys($requestQuery) as $paramName) {
			if (!in_array($paramName, $this->_allowedQueryFields)) {
				unset($canonicalQueryParams[$paramName]);
			}
		}

		ksort($canonicalQueryParams);

		if ($canonicalQueryParams !== $requestQuery) {
			return array_merge($canonicalQueryParams, $requestAttributes);
		}

		return null;
	}
}
