<?php
namespace Dalten\WebBundle\Processor;

/**
 * Obstarává převod slugů z URI na hodnoty, které by přišly z GET.
 *
 * Umožňuje tak vytvořit filtr i z pojmenovaných SEO rout.
 */
class UriParamsToQueryConverter
{
	/**
	 * Mapa ve formátu [název_parametru] => [slug => [hodnoty GET], slug2 => [GET2], ...].
	 *
	 * @var array
	 */
	private $_map = array();

	/**
	 * Konstruktor. Nastavuje převodní mapu.
	 *
	 * Převodní mapa musí být pole ve formátu [název_parametru] => [slug => [hodnoty GET], slug2 => [GET2], ...].
	 *
	 * @param array $slugToValuesMap Převodní mapa.
	 */
	public function __construct(array $slugToValuesMap)
	{
		$this->_map = $slugToValuesMap;
	}

	/**
	 * Převádí parametry (atributy) routy na GET požadavek.
	 *
	 * @param array $routeParams Pole atributů routy.
	 *
	 * @return array Pole, odpovídající atributům ve formátu jako z GET requestu.
	 */
	public function convertParamsToQuery(array $routeParams)
	{
		$query = array();
		foreach ($routeParams as $paramName => $paramValue) {
			if (isset($this->_map[$paramName][$paramValue])) {
				$query = array_replace_recursive($query, $this->_map[$paramName][$paramValue]);
			}
		}

		if (isset($routeParams['price_from'])) {
			$query['price_from'] = $routeParams['price_from'];
		}
		if (isset($routeParams['price_to'])) {
			$query['price_to'] = $routeParams['price_to'];
		}

		if (isset($routeParams['only_projects'])) {
			$query['only_projects'] = (bool) $routeParams['only_projects'];
		}

		if (isset($routeParams['discount_duration'])) {
			$query['discount_duration'] = $routeParams['discount_duration'];
		}

		if (isset($routeParams['has_open_day'])) {
			$query['has_open_day'] = $routeParams['has_open_day'];
		}

		if (isset($routeParams['company_id'])) {
			$query['company_id'] = $routeParams['company_id'];
		}

		if (isset($routeParams['broker_id'])) {
			$query['broker_id'] = $routeParams['broker_id'];
		}

		return $query;
	}
}
