<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Broker\Builder;

use Dalten\WebBundle\Filter\BrokerFilter;
use Dalten\WebBundle\Entity\Broker;
use Dalten\WebBundle\Breadcrumbs\Broker\Builder\StaticRoute;
use Mockery as m;

class StaticRouteTest extends \PHPUnit_Framework_TestCase
{
	public function testCreateBreadcrumbFromFilterReturnsSpecifiedBreadcrumb()
	{
		$config = array(
			'label' => 'bagr',
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);
		$builder = new StaticRoute($config);
		$breadcrumb = $builder->getBreadcrumbFromFilter(new BrokerFilter(array()));

		$this->assertSame($config['label'], $breadcrumb->getLabel());
		$this->assertSame($config['routeName'], $breadcrumb->getRouteName());
		$this->assertSame($config['routeParams'], $breadcrumb->getRouteParams());
	}

	public function testCreateBreadcrumbFromListingReturnsSpecifiedBreadcrumb()
	{
		$config = array(
			'label' => 'bagr',
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);
		$builder = new StaticRoute($config);
		$Broker = new Broker();
		$breadcrumb = $builder->getBreadcrumbFromBroker($Broker);

		$this->assertSame($config['label'], $breadcrumb->getLabel());
		$this->assertSame($config['routeName'], $breadcrumb->getRouteName());
		$this->assertSame($config['routeParams'], $breadcrumb->getRouteParams());
	}

}
