<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Company\Builder;

use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Company\Builder\CompanyName;
use Mockery as m;

class CompanyNameTest extends \PHPUnit_Framework_TestCase
{
	public function testCreateBreadcrumbFromFilterAlwaysReturnsNull()
	{
		$config = array(
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);
		$builder = new CompanyName($config);

		$this->assertNull($builder->getBreadcrumbFromFilter(new CompanyFilter(array())));
	}

	public function testCreateBreadcrumbFromListingReturnsSpecifiedBreadcrumb()
	{
		$config = array(
			'routeName' => 'rypadlo',
			'routeParams' => array('x' => 'y')
		);

		$company = new Company();
		$company->name = 'Test';
		$company->slug = 'test';

		$expectedRouteParams = array('x' => 'y', 'company_slug' => $company->slug);

		$expectedName = $company->name;
		$builder = new CompanyName($config);
		$breadcrumb = $builder->getBreadcrumbFromCompany($company);

		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\BreadcrumbInterface', $breadcrumb);
		$this->assertSame($expectedName, $breadcrumb->getLabel());
		$this->assertSame($config['routeName'], $breadcrumb->getRouteName());
		$this->assertSame($expectedRouteParams, $breadcrumb->getRouteParams());
	}

}
