<?php
namespace Dalten\WebBundle\Test\Breadcrumbs\Company\Builder;

use Dalten\WebBundle\Filter\AddressFilter;
use Dalten\WebBundle\Filter\CompanyFilter;
use Dalten\WebBundle\Entity\Company;
use Dalten\WebBundle\Breadcrumbs\Company\Builder\OfficeListAndCounty;
use Mockery as m;

class OfficeListAndCountyTest extends \PHPUnit_Framework_TestCase
{
	public function testBuilderCannotCreateBreadcrumbFromCompanyModel()
	{
		$company = new Company();

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumb')->never();
		$builder = new OfficeListAndCounty($helper, 'route', array());

		$this->assertNull($builder->getBreadcrumbFromCompany($company));
	}

	public function testBuilderCorrectlyCallsHelperToCreateBreadcrumbFromFilter()
	{
		$routeName = 'test';

		$filter = new CompanyFilter(array(), array(new AddressFilter(7, array())));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->with($filter, $routeName, array())->andReturn('success');
		$builder = new OfficeListAndCounty($helper, $routeName, array());

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}

	public function testBuilderPassesSpecifiedParamsIntoRouteParams()
	{
		$routeName = 'test';
		$params = array('test' => 'ok');

		$filter = new CompanyFilter(array(), array(new AddressFilter(7, array())));

		$helper = m::mock('Dalten\WebBundle\Breadcrumbs\Common\Builder\CountyHelper');
		$helper->shouldReceive('getBreadcrumbFromFilter')->with($filter, $routeName, $params)->andReturn('success');
		$builder = new OfficeListAndCounty($helper, $routeName, $params);

		$this->assertSame('success', $builder->getBreadcrumbFromFilter($filter));
	}

}
