<?php
/**
 * Created by PhpStorm.
 * User: Karel
 * Date: 14.2.14
 * Time: 14:51
 */

namespace Dalten\WebBundle\Test\Breadcrumbs\Listing\Builder;

use Dalten\WebBundle\Filter\ListingFilter;
use Dalten\WebBundle\Entity\Listing;
use Dalten\WebBundle\Breadcrumbs\Listing\Builder\ListingTypeWithSubtype;

class ListingTypeWithSubtypeTest extends \PHPUnit_Framework_TestCase
{
	private $_config = array(
		'valueMap' => array(
			'kancelare' => array(
				'acceptedValues' => array(2, 9),
				'acceptedSubtypes' => array('office_kind' => array(1), 'commercial_kind' => array(4)),
				'label' => 'Kanceláře',
				'routeParams' => array('listing_type' => 'kancelare')
			),
		),
		'routeName' => 'Test',
		'filterTypeToSubtypeMap' => array(2 => 'commercial_kind', 9 => 'office_kind')
	);

	private $_metadataConfig = array(
		'listing_office_kind' => array('type' => 'int'),
		'listing_commercial_kind' => array('type' => 'int'),
		'listing_type' => array('type' => 'int'),
	);

	public function testBuilderCanCreateBreadcrumbFromListingBasedOnSubtypes()
	{
		$listing = new Listing();
		$listing->listing_type = 9;
		$listing->listing_office_kind = 1;

		$builder = new ListingTypeWithSubtype($this->_config);

		$crumb = $builder->getBreadcrumbFromListing($listing);
		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\Breadcrumb', $crumb);
		$this->assertSame('Kanceláře', $crumb->getLabel());
		$this->assertSame(array('listing_type' => 'kancelare'), $crumb->getRouteParams());
		$this->assertSame('Test', $crumb->getRouteName());
	}

	public function testBuilderDoesNotCreateBreadcrumbFromListingIfSubtypeIsEmpty()
	{
		$listing = new Listing();
		$listing->listing_type = 9;

		$builder = new ListingTypeWithSubtype($this->_config);

		$this->assertNull($builder->getBreadcrumbFromListing($listing));
	}

	public function testBuilderDoesNotCreateBreadcrumbFromListingIfSubtypeIsNotMatched()
	{
		$listing = new Listing();
		$listing->listing_type = 9;
		$listing->listing_office_kind = 99;

		$builder = new ListingTypeWithSubtype($this->_config);

		$this->assertNull($builder->getBreadcrumbFromListing($listing));
	}

	public function testBuilderCanCreateBreadcrumbFromFilterBasedOnSubtypes()
	{
		$filter = new ListingFilter(
			array('listing_type' => array(2, 9), 'office_kind' => 1, 'commercial_kind' => 4)
		);

		$builder = new ListingTypeWithSubtype($this->_config);

		$crumb = $builder->getBreadcrumbFromFilter($filter);
		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\Breadcrumb', $crumb);
		$this->assertSame('Kanceláře', $crumb->getLabel());
		$this->assertSame(array('listing_type' => 'kancelare'), $crumb->getRouteParams());
		$this->assertSame('Test', $crumb->getRouteName());
	}

	public function testBuilderCanCreateBreadcrumbFromFilterIfOnlyASubsetOfSubtypesIsPresent()
	{
		$filter = new ListingFilter(
			array('listing_type' => array(2, 9), 'office_kind' => 1)
		);

		$builder = new ListingTypeWithSubtype($this->_config);

		$crumb = $builder->getBreadcrumbFromFilter($filter);
		$this->assertInstanceOf('Dalten\WebBundle\Breadcrumbs\Breadcrumb', $crumb);
		$this->assertSame('Kanceláře', $crumb->getLabel());
		$this->assertSame(array('listing_type' => 'kancelare'), $crumb->getRouteParams());
		$this->assertSame('Test', $crumb->getRouteName());
	}

	public function testBuilderDoesNotCreateBreadcrumbFromFilterIfMoreThanAcceptedSubtypesAreSet()
	{
		$filter = new ListingFilter(
			array('listing_type' => array(2, 9), 'office_kind' => 1, 'commercial_kind' => array(4, 3))
		);

		$builder = new ListingTypeWithSubtype($this->_config);

		$this->assertNull($builder->getBreadcrumbFromFilter($filter));
	}

	public function testBuilderDoesNotCreateBreadcrumbFromFilterIfNoListingTypeIsSet()
	{
		$filter = new ListingFilter(array('office_kind' => 1, 'commercial_kind' => 4));

		$builder = new ListingTypeWithSubtype($this->_config);
		$this->assertNull($builder->getBreadcrumbFromFilter($filter));
	}

	public function testBuilderDoesNotCreateBreadcrumbFromFilterIfNoSubtypeIsSet()
	{
		$filter = new ListingFilter(array('listing_type' => array(2, 9)));

		$builder = new ListingTypeWithSubtype($this->_config);
		$this->assertNull($builder->getBreadcrumbFromFilter($filter));
	}
}
